/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderUtils;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

class KTableBinder
extends AbstractBinder<KTable<Object, Object>, ExtendedConsumerProperties<KafkaStreamsConsumerProperties>, ExtendedProducerProperties<KafkaStreamsProducerProperties>>
implements ExtendedPropertiesBinder<KTable<Object, Object>, KafkaStreamsConsumerProperties, KafkaStreamsProducerProperties> {
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;
    private final KafkaTopicProvisioner kafkaTopicProvisioner;
    private Map<String, KafkaStreamsDlqDispatch> kafkaStreamsDlqDispatchers;
    private KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties = new KafkaStreamsExtendedBindingProperties();

    KTableBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, Map<String, KafkaStreamsDlqDispatch> kafkaStreamsDlqDispatchers) {
        this.binderConfigurationProperties = binderConfigurationProperties;
        this.kafkaTopicProvisioner = kafkaTopicProvisioner;
        this.kafkaStreamsDlqDispatchers = kafkaStreamsDlqDispatchers;
    }

    protected Binding<KTable<Object, Object>> doBindConsumer(String name, String group, KTable<Object, Object> inputTarget, ExtendedConsumerProperties<KafkaStreamsConsumerProperties> properties) {
        if (!StringUtils.hasText((String)group)) {
            group = this.binderConfigurationProperties.getApplicationId();
        }
        KafkaStreamsBinderUtils.prepareConsumerBinding(name, group, (ApplicationContext)this.getApplicationContext(), this.kafkaTopicProvisioner, this.binderConfigurationProperties, properties, this.kafkaStreamsDlqDispatchers);
        return new DefaultBinding(name, group, inputTarget, null);
    }

    protected Binding<KTable<Object, Object>> doBindProducer(String name, KTable<Object, Object> outboundBindTarget, ExtendedProducerProperties<KafkaStreamsProducerProperties> properties) {
        throw new UnsupportedOperationException("No producer level binding is allowed for KTable");
    }

    public KafkaStreamsConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (KafkaStreamsConsumerProperties)((Object)this.kafkaStreamsExtendedBindingProperties.getExtendedConsumerProperties(channelName));
    }

    public KafkaStreamsProducerProperties getExtendedProducerProperties(String channelName) {
        return (KafkaStreamsProducerProperties)((Object)this.kafkaStreamsExtendedBindingProperties.getExtendedProducerProperties(channelName));
    }

    public String getDefaultsPrefix() {
        return this.kafkaStreamsExtendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.kafkaStreamsExtendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    public void setKafkaStreamsExtendedBindingProperties(KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties) {
        this.kafkaStreamsExtendedBindingProperties = kafkaStreamsExtendedBindingProperties;
    }
}

