/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.reactorkafka;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.AdminClientConfigCustomizer;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.support.ConsumerConfigCustomizer;
import org.springframework.cloud.stream.binder.kafka.support.ProducerConfigCustomizer;
import org.springframework.cloud.stream.binder.reactorkafka.ReactorKafkaBinder;
import org.springframework.cloud.stream.binder.reactorkafka.ReactorKafkaBinderHealthIndicatorConfiguration;
import org.springframework.cloud.stream.binder.reactorkafka.ReceiverOptionsCustomizer;
import org.springframework.cloud.stream.binder.reactorkafka.SenderOptionsCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={Binder.class})
@EnableConfigurationProperties(value={KafkaProperties.class, KafkaExtendedBindingProperties.class})
@Import(value={ReactorKafkaBinderHealthIndicatorConfiguration.class})
public class ReactorKafkaBinderConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.stream.kafka.binder")
    KafkaBinderConfigurationProperties configurationProperties(KafkaProperties kafkaProperties, ObjectProvider<KafkaConnectionDetails> kafkaConnectionDetails) {
        return new KafkaBinderConfigurationProperties(kafkaProperties, kafkaConnectionDetails);
    }

    @Bean
    KafkaTopicProvisioner provisioningProvider(KafkaBinderConfigurationProperties configurationProperties, ObjectProvider<AdminClientConfigCustomizer> adminClientConfigCustomizer, KafkaProperties kafkaProperties, ObjectProvider<KafkaConnectionDetails> kafkaConnectionDetails) {
        return new KafkaTopicProvisioner(configurationProperties, kafkaProperties, (KafkaConnectionDetails)kafkaConnectionDetails.getIfAvailable(), (AdminClientConfigCustomizer)adminClientConfigCustomizer.getIfUnique());
    }

    @Bean
    ReactorKafkaBinder reactorKafkaBinder(KafkaBinderConfigurationProperties configurationProperties, KafkaTopicProvisioner provisioningProvider, KafkaExtendedBindingProperties extendedBindingProperties, ObjectProvider<ConsumerConfigCustomizer> consumerConfigCustomizer, ObjectProvider<ProducerConfigCustomizer> producerConfigCustomizer, ObjectProvider<ReceiverOptionsCustomizer> receiverOptionsCustomizers, ObjectProvider<SenderOptionsCustomizer> senderOptionsptionsCustomizers) {
        ReactorKafkaBinder reactorKafkaBinder = new ReactorKafkaBinder(configurationProperties, provisioningProvider);
        reactorKafkaBinder.setExtendedBindingProperties(extendedBindingProperties);
        reactorKafkaBinder.setConsumerConfigCustomizer((ConsumerConfigCustomizer)consumerConfigCustomizer.getIfUnique());
        reactorKafkaBinder.setProducerConfigCustomizer((ProducerConfigCustomizer)producerConfigCustomizer.getIfUnique());
        reactorKafkaBinder.receiverOptionsCustomizers(receiverOptionsCustomizers);
        reactorKafkaBinder.senderOptionsCustomizers(senderOptionsptionsCustomizers);
        return reactorKafkaBinder;
    }
}

