/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.reactorkafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.reactorkafka.ReactorKafkaBinder;
import org.springframework.cloud.stream.binder.reactorkafka.ReactorKafkaBinderHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.util.ObjectUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
@ConditionalOnEnabledHealthIndicator(value="binders")
public class ReactorKafkaBinderHealthIndicatorConfiguration {
    @Bean
    public ReactorKafkaBinderHealthIndicator reactorKafkaBinderHealthIndicator(ReactorKafkaBinder reactorKafkaBinder, KafkaBinderConfigurationProperties configurationProperties) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key.deserializer", ByteArrayDeserializer.class);
        props.put("value.deserializer", ByteArrayDeserializer.class);
        Map mergedConfig = configurationProperties.mergedConsumerConfiguration();
        if (!ObjectUtils.isEmpty((Object)mergedConfig)) {
            props.putAll(mergedConfig);
        }
        if (!props.containsKey("bootstrap.servers")) {
            props.put("bootstrap.servers", configurationProperties.getKafkaConnectionString());
        }
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(props);
        ReactorKafkaBinderHealthIndicator indicator = new ReactorKafkaBinderHealthIndicator(reactorKafkaBinder, (ConsumerFactory<?, ?>)consumerFactory);
        indicator.setTimeout(configurationProperties.getHealthTimeout());
        indicator.setConsiderDownWhenAnyPartitionHasNoLeader(configurationProperties.isConsiderDownWhenAnyPartitionHasNoLeader());
        return indicator;
    }
}

