/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.sampler.SamplerAutoConfiguration;
import org.springframework.cloud.sleuth.zipkin2.DefaultEndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.DefaultZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinSenderConfigurationImportSelector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ZipkinProperties.class})
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.zipkin.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TraceAutoConfiguration.class})
@AutoConfigureAfter(name={"org.springframework.cloud.autoconfigure.RefreshAutoConfiguration"})
@Import(value={ZipkinSenderConfigurationImportSelector.class, SamplerAutoConfiguration.class})
public class ZipkinAutoConfiguration {
    private static final Log log = LogFactory.getLog(ZipkinAutoConfiguration.class);
    public static final String REPORTER_BEAN_NAME = "zipkinReporter";
    public static final String SENDER_BEAN_NAME = "zipkinSender";

    @Bean(value={"zipkinReporter"})
    @ConditionalOnMissingBean(name={"zipkinReporter"})
    public Reporter<Span> reporter(ReporterMetrics reporterMetrics, ZipkinProperties zipkin, @Qualifier(value="zipkinSender") Sender sender) {
        AsyncReporter asyncReporter = AsyncReporter.builder((Sender)sender).queuedMaxSpans(1000).messageTimeout((long)zipkin.getMessageTimeout(), TimeUnit.SECONDS).metrics(reporterMetrics).build((BytesEncoder)zipkin.getEncoder());
        CheckResult checkResult = this.checkResult((AsyncReporter<Span>)asyncReporter);
        this.logCheckResult(asyncReporter, checkResult);
        return asyncReporter;
    }

    private void logCheckResult(AsyncReporter asyncReporter, CheckResult checkResult) {
        if (log.isDebugEnabled() && checkResult != null && checkResult.ok()) {
            log.debug((Object)("Check result of the [" + asyncReporter.toString() + "] is [" + checkResult + "]"));
        } else if (checkResult != null && !checkResult.ok()) {
            log.warn((Object)("Check result of the [" + asyncReporter.toString() + "] contains an error [" + checkResult + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckResult checkResult(AsyncReporter<Span> asyncReporter) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<CheckResult> task = () -> asyncReporter.check();
        Future<CheckResult> future = executor.submit(task);
        try {
            CheckResult checkResult = future.get(1L, TimeUnit.SECONDS);
            return checkResult;
        }
        catch (Exception ex) {
            log.warn((Object)"An exception took place when trying to retrieve the check result. Will return null.", (Throwable)ex);
            CheckResult checkResult = null;
            return checkResult;
        }
        finally {
            future.cancel(true);
            executor.shutdown();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public ZipkinRestTemplateCustomizer zipkinRestTemplateCustomizer(ZipkinProperties zipkinProperties) {
        return new DefaultZipkinRestTemplateCustomizer(zipkinProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Registration.class})
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="true")
    protected static class RegistrationEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Autowired
        private Environment environment;
        @Autowired(required=false)
        private Registration registration;

        protected RegistrationEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new DefaultEndpointLocator(this.registration, this.serverProperties, this.environment, this.zipkinProperties, this.inetUtils);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="false", matchIfMissing=true)
    protected static class DefaultEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Autowired
        private Environment environment;

        protected DefaultEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new DefaultEndpointLocator(null, this.serverProperties, this.environment, this.zipkinProperties, this.inetUtils);
        }
    }
}

