/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.io.Closeable;
import java.io.Flushable;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.zipkin.ReporterMetricsAdapter;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import zipkin.Span;
import zipkin.reporter.AsyncReporter;
import zipkin.reporter.ReporterMetrics;
import zipkin.reporter.Sender;
import zipkin.reporter.urlconnection.URLConnectionSender;

public final class HttpZipkinSpanReporter
implements ZipkinSpanReporter,
Flushable,
Closeable {
    private final URLConnectionSender sender;
    private final AsyncReporter<Span> delegate;

    public HttpZipkinSpanReporter(String baseUrl, int flushInterval, boolean compressionEnabled, SpanMetricReporter spanMetricReporter) {
        this.sender = URLConnectionSender.builder().endpoint(baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v1/spans").compressionEnabled(compressionEnabled).build();
        this.delegate = AsyncReporter.builder((Sender)this.sender).queuedMaxSpans(1000).messageTimeout((long)flushInterval, TimeUnit.SECONDS).metrics((ReporterMetrics)new ReporterMetricsAdapter(spanMetricReporter)).build();
    }

    @Override
    public void report(Span span) {
        this.delegate.report((Object)span);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
        this.sender.close();
    }
}

