/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.zipkin.DiscoveryClientEndpointLocator;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin.ServerPropertiesEndpointLocator;
import zipkin.Endpoint;

public class FallbackHavingEndpointLocator
implements EndpointLocator {
    private final AtomicReference<Endpoint> cachedEndpoint = new AtomicReference();
    private static final Log log = LogFactory.getLog(FallbackHavingEndpointLocator.class);
    private final DiscoveryClientEndpointLocator discoveryClientEndpointLocator;
    private final ServerPropertiesEndpointLocator serverPropertiesEndpointLocator;

    public FallbackHavingEndpointLocator(DiscoveryClientEndpointLocator discoveryClientEndpointLocator, ServerPropertiesEndpointLocator serverPropertiesEndpointLocator) {
        this.discoveryClientEndpointLocator = discoveryClientEndpointLocator;
        this.serverPropertiesEndpointLocator = serverPropertiesEndpointLocator;
    }

    @Override
    public Endpoint local() {
        this.cachedEndpoint.compareAndSet(null, this.endpoint());
        return this.cachedEndpoint.get();
    }

    private Endpoint endpoint() {
        if (this.discoveryClientEndpointLocator == null) {
            return this.serverPropertiesEndpointLocator.local();
        }
        try {
            return this.discoveryClientEndpointLocator.local();
        }
        catch (Exception e) {
            log.warn((Object)"Exception occurred while trying to fetch the Zipkin process endpoint. Falling back to server properties endpoint locator.", (Throwable)e);
            return this.serverPropertiesEndpointLocator.local();
        }
    }
}

