/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.exception;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"spring.application.name=exceptionservice"})
public class WebClientExceptionTests {
    private static final Log log = LogFactory.getLog(WebClientExceptionTests.class);
    @Autowired
    TestFeignInterfaceWithException testFeignInterfaceWithException;
    @Autowired
    @LoadBalanced
    RestTemplate template;
    @Autowired
    Tracer tracer;
    @Autowired
    TestSpanHandler spans;

    @BeforeEach
    public void open() {
        this.spans.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"parametersForShouldCloseSpanUponException"})
    @DirtiesContext
    public void shouldCloseSpanUponException(ResponseEntityProvider provider) throws IOException {
        Span span = this.tracer.nextSpan().name("new trace").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            log.info((Object)("Started new span " + span));
            provider.get(this);
            Assertions.fail((String)"should throw an exception");
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).isNotEmpty();
            log.info((Object)("Reported spans are not empty [" + this.spans + "]"));
            BDDAssertions.then((Throwable)this.spans.get(0).getError()).isNotNull();
        });
    }

    static Stream<Object> parametersForShouldCloseSpanUponException() {
        return Stream.of(tests -> tests.testFeignInterfaceWithException.shouldFailToConnect(), tests -> tests.template.getForEntity("https://exceptionservice/", Map.class, new Object[0]));
    }

    @Configuration(proxyBeanMethods=false)
    public static class ExceptionServiceLoadBalancerClientConfiguration {
        @Bean
        public ServiceInstanceListSupplier serviceInstanceListSupplier() {
            return ServiceInstanceListSuppliers.from((String)"exceptionservice", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("exceptionservice-1", "exceptionservice", "invalid.host.to.break.tests", 1234, false)});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableFeignClients
    @LoadBalancerClient(value="exceptionservice", configuration={ExceptionServiceLoadBalancerClientConfiguration.class})
    public static class TestConfiguration {
        @LoadBalanced
        @Bean
        public RestTemplate restTemplate() {
            SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
            clientHttpRequestFactory.setReadTimeout(1);
            clientHttpRequestFactory.setConnectTimeout(1);
            return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        }
    }

    @FunctionalInterface
    static interface ResponseEntityProvider {
        public ResponseEntity<?> get(WebClientExceptionTests var1);
    }

    @FeignClient(value="exceptionservice")
    public static interface TestFeignInterfaceWithException {
        @RequestMapping(method={RequestMethod.GET}, value={"/"})
        public ResponseEntity<String> shouldFailToConnect();
    }
}

