/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.quartz;

import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.listeners.JobListenerSupport;
import org.quartz.listeners.TriggerListenerSupport;
import org.quartz.utils.StringKeyDirtyFlagMap;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.quartz.SleuthQuartzSpan;
import org.springframework.cloud.sleuth.instrument.quartz.TracingJobListener;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

public abstract class TracingJobListenerTest
implements TestTracingAwareSupplier {
    private static final JobKey SUCCESSFUL_JOB_KEY = new JobKey("SuccessfulJob");
    private static final JobKey EXCEPTIONAL_JOB_KEY = new JobKey("ExceptionalJob");
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("ExampleTrigger");
    private TracingJobListener listener;
    private Scheduler scheduler;
    private CompletableFuture completableJob;

    @BeforeEach
    public void setUp() throws Exception {
        this.listener = new TracingJobListener(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().propagator());
        this.completableJob = new CompleteableTriggerListener();
        this.scheduler = this.createScheduler(this.getClass().getSimpleName(), 1);
        this.scheduler.addJob(JobBuilder.newJob(ExceptionalJob.class).withIdentity(EXCEPTIONAL_JOB_KEY).storeDurably().build(), true);
        this.scheduler.addJob(JobBuilder.newJob(SuccessfulJob.class).withIdentity(SUCCESSFUL_JOB_KEY).storeDurably().build(), true);
        this.scheduler.getListenerManager().addTriggerListener((TriggerListener)this.listener);
        this.scheduler.getListenerManager().addJobListener((JobListener)this.listener);
        this.scheduler.getListenerManager().addTriggerListener((TriggerListener)((CompleteableTriggerListener)this.completableJob));
        this.scheduler.getListenerManager().addJobListener((JobListener)((CompleteableTriggerListener)this.completableJob));
        this.scheduler.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.scheduler.shutdown(true);
    }

    @Test
    public void should_return_class_name_all_the_time() {
        String name = this.listener.getName();
        Assertions.assertThat((String)name).isEqualTo(TracingJobListener.class.getName());
    }

    @Test
    public void should_complete_span_when_job_is_successful() throws Exception {
        Trigger trigger = TriggerBuilder.newTrigger().forJob(SUCCESSFUL_JOB_KEY).startNow().build();
        this.runJob(trigger);
        this.tracerTest().handler().takeLocalSpan();
    }

    @Test
    public void should_have_span_with_proper_name_and_tag_when_job_is_successful() throws Exception {
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).forJob(SUCCESSFUL_JOB_KEY).startNow().build();
        this.runJob(trigger);
        FinishedSpan span = this.tracerTest().handler().takeLocalSpan();
        Assertions.assertThat((String)span.getName()).isEqualToIgnoringCase((CharSequence)SUCCESSFUL_JOB_KEY.toString());
        Assertions.assertThat((String)((String)span.getTags().get(SleuthQuartzSpan.Tags.TRIGGER.getKey()))).isEqualToIgnoringCase((CharSequence)TRIGGER_KEY.toString());
    }

    @Test
    public void should_complete_span_when_job_throws_exception() throws Exception {
        Trigger trigger = TriggerBuilder.newTrigger().forJob(EXCEPTIONAL_JOB_KEY).startNow().build();
        this.runJob(trigger);
        this.tracerTest().handler().takeLocalSpan();
    }

    @Test
    public void should_complete_span_when_job_is_vetoed() throws Exception {
        this.scheduler.getListenerManager().addTriggerListener((TriggerListener)new VetoJobTriggerListener());
        Trigger trigger = TriggerBuilder.newTrigger().forJob(SUCCESSFUL_JOB_KEY).startNow().build();
        this.runJob(trigger);
        this.tracerTest().handler().takeLocalSpan();
    }

    @Test
    public void should_not_complete_span_when_context_is_modified_to_remove_keys() throws Exception {
        this.scheduler.getListenerManager().addJobListener((JobListener)new ContextModifyingJobListener());
        Trigger trigger = TriggerBuilder.newTrigger().forJob(EXCEPTIONAL_JOB_KEY).startNow().build();
        this.runJob(trigger);
    }

    @Test
    public void should_have_parent_and_child_span_when_trigger_contains_span_info() throws Exception {
        JobDataMap data = new JobDataMap();
        this.addSpanToJobData(data);
        Trigger trigger = TriggerBuilder.newTrigger().forJob(SUCCESSFUL_JOB_KEY).usingJobData(data).startNow().build();
        this.runJob(trigger);
        FinishedSpan parent = this.tracerTest().handler().takeLocalSpan();
        FinishedSpan child = this.tracerTest().handler().takeLocalSpan();
        this.tracerTest().assertions().assertThatNoParentPresent(parent);
        Assertions.assertThat((String)child.getParentId()).isEqualTo(parent.getSpanId());
    }

    @Test
    public void should_have_parent_and_child_span_when_trigger_job_data_was_created_with_differently_typed_map() throws Exception {
        JobDataMap data = new JobDataMap(new HashMap());
        this.addSpanToJobData(data);
        Trigger trigger = TriggerBuilder.newTrigger().forJob(SUCCESSFUL_JOB_KEY).usingJobData(data).startNow().build();
        this.runJob(trigger);
        FinishedSpan parent = this.tracerTest().handler().takeLocalSpan();
        FinishedSpan child = this.tracerTest().handler().takeLocalSpan();
        this.tracerTest().assertions().assertThatNoParentPresent(parent);
        Assertions.assertThat((Object)child).isNotNull();
        Assertions.assertThat((String)child.getParentId()).isEqualTo(parent.getSpanId());
    }

    void runJob(Trigger trigger) throws SchedulerException {
        this.scheduler.scheduleJob(trigger);
        this.completableJob.join();
    }

    Scheduler createScheduler(String name, int threadPoolSize) throws SchedulerException {
        Properties config = new Properties();
        config.setProperty("org.quartz.scheduler.instanceName", name + "Scheduler");
        config.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        config.setProperty("org.quartz.threadPool.threadCount", Integer.toString(threadPoolSize));
        config.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        return new StdSchedulerFactory(config).getScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSpanToJobData(JobDataMap data) {
        Span span = this.tracerTest().tracing().tracer().nextSpan().start();
        try (Tracer.SpanInScope spanInScope = this.tracerTest().tracing().tracer().withSpan(span);){
            this.tracerTest().tracing().propagator().inject(this.tracerTest().tracing().currentTraceContext().context(), (Object)data, StringKeyDirtyFlagMap::put);
        }
        finally {
            span.end();
        }
    }

    public static class SuccessfulJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
        }
    }

    public static class ExceptionalJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            throw new RuntimeException("Intentional Exception");
        }
    }

    public static class ContextModifyingJobListener
    extends JobListenerSupport {
        public String getName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public void jobToBeExecuted(JobExecutionContext context) {
            context.put((Object)TracingJobListener.CONTEXT_SPAN_KEY, null);
            context.put((Object)TracingJobListener.CONTEXT_SPAN_IN_SCOPE_KEY, null);
        }
    }

    public static class VetoJobTriggerListener
    extends TriggerListenerSupport {
        public String getName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
            return true;
        }
    }

    public static class CompleteableTriggerListener
    extends CompletableFuture
    implements TriggerListener,
    JobListener {
        public String getName() {
            return this.getClass().getName();
        }

        public void triggerFired(Trigger trigger, JobExecutionContext context) {
        }

        public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
            return false;
        }

        public void triggerMisfired(Trigger trigger) {
        }

        public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
            this.complete(context.getResult());
        }

        public void jobToBeExecuted(JobExecutionContext context) {
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
            this.complete(context.getResult());
        }

        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        }
    }
}

