/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.util.StringUtils;

public class OtelTraceContextBuilder
implements TraceContext.Builder {
    private String traceId;
    private String parentId;
    private String spanId;
    private Boolean sampled;

    public TraceContext.Builder traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public TraceContext.Builder parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public TraceContext.Builder spanId(String spanId) {
        this.spanId = spanId;
        return this;
    }

    public TraceContext.Builder sampled(Boolean sampled) {
        this.sampled = sampled;
        return this;
    }

    public TraceContext build() {
        if (StringUtils.hasText((String)this.parentId)) {
            return new OtelTraceContext(SpanContext.createFromRemoteParent((String)this.traceId, (String)this.spanId, (TraceFlags)(this.sampled != false ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault()), null);
        }
        return new OtelTraceContext(SpanContext.create((String)this.traceId, (String)this.spanId, (TraceFlags)(this.sampled != false ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault()), null);
    }
}

