/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.internal.Utils;
import java.util.Arrays;

final class BigendianEncoding {
    static final int LONG_BYTES = 8;
    static final int BYTE_BASE16 = 2;
    static final int LONG_BASE16 = 16;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final byte[] DECODING = BigendianEncoding.buildDecodingArray();

    private BigendianEncoding() {
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    static long longFromBase16String(CharSequence chars) {
        return BigendianEncoding.longFromBase16String(chars, 0);
    }

    static long longFromBase16String(CharSequence chars, int offset) {
        Utils.checkArgument((chars.length() >= offset + 16 ? 1 : 0) != 0, (String)"chars too small");
        return ((long)BigendianEncoding.decodeByte(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)BigendianEncoding.decodeByte(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
    }

    private static byte decodeByte(char hi, char lo) {
        Utils.checkArgument((lo < '\u0080' && DECODING[lo] != -1 ? 1 : 0) != 0, (String)("invalid character " + lo));
        Utils.checkArgument((hi < '\u0080' && DECODING[hi] != -1 ? 1 : 0) != 0, (String)("invalid character " + hi));
        int decoded = DECODING[hi] << 4 | DECODING[lo];
        return (byte)decoded;
    }
}

