/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(TempFileUtils.class);

    public static Path createTempDirectory(String rootName) {
        try {
            logger.debug("Creating temp directory with root name {}", (Object)rootName);
            Path pathToReturn = Files.createTempDirectory(rootName, new FileAttribute[0]);
            logger.debug("Created temp directory {}", (Object)pathToReturn.toString());
            return pathToReturn;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create temp directory", e);
        }
    }
}

