/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.server.local.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.skipper.server.local.security.support.OAuth2TestServer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.SocketUtils;

public class OAuth2ServerResource
extends ExternalResource {
    private static final String OAUTH2_PORT_PROPERTY = "oauth2.port";
    private final Log LOGGER = LogFactory.getLog(OAuth2ServerResource.class);
    private String originalOAuth2Port;
    private int oauth2ServerPort;
    private ConfigurableApplicationContext application;

    protected void before() throws Throwable {
        this.originalOAuth2Port = System.getProperty(OAUTH2_PORT_PROPERTY);
        this.oauth2ServerPort = SocketUtils.findAvailableTcpPort();
        this.LOGGER.info((Object)("Setting OAuth2 Server port to " + this.oauth2ServerPort));
        System.setProperty(OAUTH2_PORT_PROPERTY, String.valueOf(this.oauth2ServerPort));
        this.application = new SpringApplicationBuilder(new Object[]{OAuth2TestServer.class}).build().run(new String[]{"--spring.config.location=classpath:/org/springframework/cloud/skipper/server/local/security/support/oauth2TestServerConfig.yml"});
    }

    protected void after() {
        try {
            this.application.stop();
        }
        finally {
            if (this.originalOAuth2Port != null) {
                System.setProperty(OAUTH2_PORT_PROPERTY, this.originalOAuth2Port);
            } else {
                System.clearProperty(OAUTH2_PORT_PROPERTY);
            }
        }
    }

    public int getOauth2ServerPort() {
        return this.oauth2ServerPort;
    }
}

