/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.server.local.security;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.cloud.skipper.server.local.security.LocalSkipperResource;
import org.springframework.cloud.skipper.server.local.security.OAuth2ServerResource;
import org.springframework.cloud.skipper.server.local.security.SecurityTestUtils;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LocalServerSecurityWithOAuth2Tests {
    private static final OAuth2ServerResource oAuth2ServerResource = new OAuth2ServerResource();
    private static final LocalSkipperResource localSkipperResource = new LocalSkipperResource(new String[]{"spring.config.location:classpath:/", "classpath:/org/springframework/cloud/skipper/server/local/security/"}, new String[]{"application", "oauthConfig"});
    @ClassRule
    public static TestRule springSkipperAndOauthServer = RuleChain.outerRule((TestRule)oAuth2ServerResource).around((TestRule)localSkipperResource);

    @Test
    public void testAccessRootUrlWithoutCredentials() throws Exception {
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0])).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().is3xxRedirection());
    }

    @Test
    public void testAccessApiUrlWithBasicAuthCredentials() throws Exception {
        localSkipperResource.getWebApplicationContext().getEnvironment().getPropertySources();
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "secret10")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testAccessRootUrlWithBasicAuthCredentials() throws Exception {
        localSkipperResource.getWebApplicationContext().getEnvironment().getPropertySources();
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "secret10")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().is3xxRedirection());
    }

    @Test
    public void testAccessRootUrlWithBasicAuthCredentialsWrongPassword() throws Exception {
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "wrong-password")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testThatAccessToActuatorEndpointPromptsSecurity() throws Exception {
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/actuator/env", (Object[])new Object[0])).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testAccessToActuatorEndpointWithBasicAuthCredentialsWrongPassword() throws Exception {
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/actuator/env", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "wrong-password")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testThatAccessToActuatorEndpointWithBasicAuthCredentialsSucceeds() throws Exception {
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/actuator/env", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "secret10")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testThatAccessToActuatorEndpointRootWithBasicAuthCredentialsSucceeds() throws Exception {
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/actuator", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "secret10")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testAccessRootUrlWithOAuth2AccessToken() throws Exception {
        ClientCredentialsResourceDetails resourceDetails = new ClientCredentialsResourceDetails();
        resourceDetails.setClientId("myclient");
        resourceDetails.setClientSecret("mysecret");
        resourceDetails.setGrantType("client_credentials");
        resourceDetails.setAccessTokenUri("http://localhost:" + oAuth2ServerResource.getOauth2ServerPort() + "/oauth/token");
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resourceDetails);
        OAuth2AccessToken accessToken = oAuth2RestTemplate.getAccessToken();
        String accessTokenAsString = accessToken.getValue();
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0]).header("Authorization", new Object[]{"bearer " + accessTokenAsString})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testAccessAboutUrlWithOAuth2AccessToken() throws Exception {
        ClientCredentialsResourceDetails resourceDetails = new ClientCredentialsResourceDetails();
        resourceDetails.setClientId("myclient");
        resourceDetails.setClientSecret("mysecret");
        resourceDetails.setGrantType("client_credentials");
        resourceDetails.setAccessTokenUri("http://localhost:" + oAuth2ServerResource.getOauth2ServerPort() + "/oauth/token");
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resourceDetails);
        OAuth2AccessToken accessToken = oAuth2RestTemplate.getAccessToken();
        String accessTokenAsString = accessToken.getValue();
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/about", (Object[])new Object[0]).header("Authorization", new Object[]{"bearer " + accessTokenAsString})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.versionInfo.server.name", (Matcher)Matchers.is((Object)"Spring Cloud Skipper Server"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.versionInfo.server.version", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAccessRootUrlWithWrongOAuth2AccessToken() throws Exception {
        localSkipperResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{"bearer 123456"})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

