/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.server.local.security;

import java.util.Collection;
import javax.servlet.Filter;
import org.junit.rules.ExternalResource;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.skipper.server.local.security.skipperapp.LocalTestSkipperServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class LocalSkipperResource
extends ExternalResource {
    private SpringApplication app;
    private MockMvc mockMvc;
    private String skipperPort;
    private final String[] configLocations;
    private final String[] configNames;
    private final String[] args;
    private ConfigurableApplicationContext configurableApplicationContext;

    public LocalSkipperResource(String[] configLocations, String[] configNames, String[] args) {
        this.configLocations = configLocations;
        this.configNames = configNames;
        this.args = args;
    }

    public LocalSkipperResource(String[] configLocations, String[] configNames) {
        this(configLocations, configNames, new String[]{"--server.port=0"});
    }

    protected void before() throws Throwable {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{LocalTestSkipperServer.class});
        if (this.configLocations != null && this.configLocations.length > 0) {
            builder.properties(new String[]{String.format("spring.config.location:%s", StringUtils.arrayToCommaDelimitedString((Object[])this.configLocations))});
        }
        if (this.configNames != null && this.configNames.length > 0) {
            builder.properties(new String[]{String.format("spring.config.name:%s", StringUtils.arrayToCommaDelimitedString((Object[])this.configNames))});
        }
        this.app = builder.build();
        this.configurableApplicationContext = this.app.run(this.args);
        Collection filters = this.configurableApplicationContext.getBeansOfType(Filter.class).values();
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)((WebApplicationContext)this.configurableApplicationContext)).addFilters(filters.toArray(new Filter[filters.size()]))).build();
        this.skipperPort = this.configurableApplicationContext.getEnvironment().resolvePlaceholders("${server.port}");
    }

    protected void after() {
        SpringApplication.exit((ApplicationContext)this.configurableApplicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
    }

    public MockMvc getMockMvc() {
        return this.mockMvc;
    }

    public String getSkipperPort() {
        return this.skipperPort;
    }

    public ConfigurableApplicationContext getWebApplicationContext() {
        return this.configurableApplicationContext;
    }
}

