/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.client.util;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.cloud.skipper.client.util.HttpUtils;
import org.springframework.cloud.skipper.client.util.PreemptiveBasicAuthHttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class HttpClientConfigurer {
    private final HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
    private boolean useBasicAuth;
    private HttpHost targetHost;

    protected HttpClientConfigurer() {
    }

    public static HttpClientConfigurer create() {
        return new HttpClientConfigurer();
    }

    public HttpClientConfigurer basicAuthCredentials(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        this.httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        this.useBasicAuth = true;
        return this;
    }

    public HttpClientConfigurer skipTlsCertificateVerification() {
        this.httpClientBuilder.setSSLContext(HttpUtils.buildCertificateIgnoringSslContext());
        this.httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        return this;
    }

    public HttpClientConfigurer skipTlsCertificateVerification(boolean skipTlsCertificateVerification) {
        if (skipTlsCertificateVerification) {
            this.skipTlsCertificateVerification();
        }
        return this;
    }

    public HttpClientConfigurer targetHost(URI targetHost) {
        this.targetHost = new HttpHost(targetHost.getHost(), targetHost.getPort(), targetHost.getScheme());
        return this;
    }

    public HttpClientConfigurer addInterceptor(HttpRequestInterceptor interceptor) {
        this.httpClientBuilder.addInterceptorLast(interceptor);
        return this;
    }

    public CloseableHttpClient buildHttpClient() {
        return this.httpClientBuilder.build();
    }

    public ClientHttpRequestFactory buildClientHttpRequestFactory() {
        if (this.useBasicAuth && this.targetHost != null) {
            return new PreemptiveBasicAuthHttpComponentsClientHttpRequestFactory((HttpClient)this.buildHttpClient(), this.targetHost);
        }
        return new HttpComponentsClientHttpRequestFactory((HttpClient)this.buildHttpClient());
    }
}

