/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="turbine")
public class TurbineProperties {
    private String clusterNameExpression;
    private String appConfig;
    private boolean combineHostPort = true;

    public List<String> getAppConfigList() {
        if (!StringUtils.hasText((String)this.appConfig)) {
            return null;
        }
        String[] parts = StringUtils.commaDelimitedListToStringArray((String)this.appConfig);
        if (parts != null && parts.length > 0) {
            parts = StringUtils.trimArrayElements((String[])parts);
            return Arrays.asList(parts);
        }
        return null;
    }

    public String getClusterNameExpression() {
        return this.clusterNameExpression;
    }

    public void setClusterNameExpression(String clusterNameExpression) {
        this.clusterNameExpression = clusterNameExpression;
    }

    public String getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(String appConfig) {
        this.appConfig = appConfig;
    }

    public boolean isCombineHostPort() {
        return this.combineHostPort;
    }

    public void setCombineHostPort(boolean combineHostPort) {
        this.combineHostPort = combineHostPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TurbineProperties that = (TurbineProperties)o;
        return Objects.equals(this.clusterNameExpression, that.clusterNameExpression) && Objects.equals(this.appConfig, that.appConfig) && Objects.equals(this.combineHostPort, that.combineHostPort);
    }

    public int hashCode() {
        return Objects.hash(this.clusterNameExpression, this.appConfig, this.combineHostPort);
    }

    public String toString() {
        return "TurbineProperties{" + "clusterNameExpression='" + this.clusterNameExpression + "', " + "appConfig='" + this.appConfig + "', " + "combineHostPort=" + this.combineHostPort + "}";
    }
}

