/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.discovery.EurekaClient;
import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import com.netflix.turbine.streaming.servlet.TurbineStreamServlet;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.turbine.CommonsInstanceDiscovery;
import org.springframework.cloud.netflix.turbine.ConfigurationBasedTurbineClustersProvider;
import org.springframework.cloud.netflix.turbine.EurekaInstanceDiscovery;
import org.springframework.cloud.netflix.turbine.SpringAggregatorFactory;
import org.springframework.cloud.netflix.turbine.TurbineAggregatorProperties;
import org.springframework.cloud.netflix.turbine.TurbineClustersProvider;
import org.springframework.cloud.netflix.turbine.TurbineController;
import org.springframework.cloud.netflix.turbine.TurbineInformationService;
import org.springframework.cloud.netflix.turbine.TurbineLifecycle;
import org.springframework.cloud.netflix.turbine.TurbineProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
public class TurbineHttpConfiguration {
    @Bean
    public HasFeatures Feature() {
        return HasFeatures.namedFeature((String)"Turbine (HTTP)", TurbineHttpConfiguration.class);
    }

    @Bean
    @ConditionalOnMissingBean(name={"turbineStreamServlet"})
    public ServletRegistrationBean turbineStreamServlet() {
        return new ServletRegistrationBean((Servlet)new TurbineStreamServlet(), new String[]{"/turbine.stream"});
    }

    @Bean
    @ConditionalOnMissingBean
    public TurbineProperties turbineProperties() {
        return new TurbineProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public TurbineInformationService turbineInformationService() {
        return new TurbineInformationService();
    }

    @Bean
    @ConditionalOnProperty(value={"turbine.endpoints.clusters.enabled"}, matchIfMissing=true)
    public TurbineController turbineController(TurbineInformationService service) {
        return new TurbineController(service);
    }

    @Bean
    @ConditionalOnMissingBean
    public TurbineAggregatorProperties turbineAggregatorProperties() {
        return new TurbineAggregatorProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public TurbineLifecycle turbineLifecycle(InstanceDiscovery instanceDiscovery, ClusterMonitorFactory<?> factory) {
        return new TurbineLifecycle(instanceDiscovery, factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public ClusterMonitorFactory clusterMonitorFactory(TurbineClustersProvider clustersProvider) {
        return new SpringAggregatorFactory(clustersProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public TurbineClustersProvider clustersProvider(TurbineAggregatorProperties turbineAggregatorProperties) {
        return new ConfigurationBasedTurbineClustersProvider(turbineAggregatorProperties);
    }

    @Configuration
    @ConditionalOnMissingClass(value={"com.netflix.discovery.EurekaClient"})
    protected static class DiscoveryClientTurbineConfiguration {
        protected DiscoveryClientTurbineConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public InstanceDiscovery instanceDiscovery(TurbineProperties turbineProperties, DiscoveryClient discoveryClient) {
            return new CommonsInstanceDiscovery(turbineProperties, discoveryClient);
        }
    }

    @Configuration
    @ConditionalOnClass(value={EurekaClient.class})
    protected static class EurekaTurbineConfiguration {
        protected EurekaTurbineConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public InstanceDiscovery instanceDiscovery(TurbineProperties turbineProperties, EurekaClient eurekaClient) {
            return new EurekaInstanceDiscovery(turbineProperties, eurekaClient);
        }
    }
}

