/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.sidecar;

import java.net.URI;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="sidecar")
public class SidecarProperties {
    private URI healthUri;
    private URI homePageUri;
    @Max(value=65535L)
    @Min(value=1L)
    private @Max(value=65535L) @Min(value=1L) int port;
    private String hostname;
    private String ipAddress;
    private boolean acceptAllSslCertificates;

    public URI getHealthUri() {
        return this.healthUri;
    }

    public void setHealthUri(URI healthUri) {
        this.healthUri = healthUri;
    }

    public URI getHomePageUri() {
        return this.homePageUri;
    }

    public void setHomePageUri(URI homePageUri) {
        this.homePageUri = homePageUri;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean acceptAllSslCertificates() {
        return this.acceptAllSslCertificates;
    }

    public void setAcceptAllSslCertificates(boolean acceptAllSslCertificates) {
        this.acceptAllSslCertificates = acceptAllSslCertificates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidecarProperties that = (SidecarProperties)o;
        return Objects.equals(this.healthUri, that.healthUri) && Objects.equals(this.homePageUri, that.homePageUri) && this.port == that.port && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.acceptAllSslCertificates, that.acceptAllSslCertificates);
    }

    public int hashCode() {
        return Objects.hash(this.healthUri, this.homePageUri, this.port, this.hostname, this.ipAddress, this.acceptAllSslCertificates);
    }

    public String toString() {
        return "SidecarProperties{" + "healthUri=" + this.healthUri + ", " + "homePageUri=" + this.homePageUri + ", " + "port=" + this.port + ", " + "hostname='" + this.hostname + "', " + "ipAddress='" + this.ipAddress + "', " + "acceptAllSslCertificates='" + this.acceptAllSslCertificates + "'}";
    }
}

