/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server.metrics;

import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.cloud.netflix.eureka.server.EurekaServerAutoConfiguration;
import org.springframework.cloud.netflix.eureka.server.metrics.DefaultEurekaInstanceTagsProvider;
import org.springframework.cloud.netflix.eureka.server.metrics.EurekaInstanceMonitor;
import org.springframework.cloud.netflix.eureka.server.metrics.EurekaInstanceTagsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@ConditionalOnClass(value={MeterRegistry.class, ThreadPoolTaskExecutor.class})
@ConditionalOnBean(value={MeterRegistry.class})
@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, EurekaServerAutoConfiguration.class, TaskExecutionAutoConfiguration.class})
@ConditionalOnProperty(name={"eureka.server.metrics.enabled"}, havingValue="true")
class EurekaInstanceMetricsAutoConfiguration {
    EurekaInstanceMetricsAutoConfiguration() {
    }

    @ConditionalOnMissingBean
    @Bean
    public EurekaInstanceTagsProvider eurekaInstanceTagProvider() {
        return new DefaultEurekaInstanceTagsProvider();
    }

    @ConditionalOnMissingBean
    @Bean
    public EurekaInstanceMonitor eurekaInstanceMeterBinder(MeterRegistry meterRegistry, PeerAwareInstanceRegistry instanceRegistry, EurekaInstanceTagsProvider tagProvider, @Qualifier(value="applicationTaskExecutor") TaskExecutor executor) {
        return new EurekaInstanceMonitor(meterRegistry, instanceRegistry, tagProvider, (Executor)executor);
    }
}

