/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.ribbon;

import com.netflix.loadbalancer.Server;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.ribbon.KubernetesRibbonProperties;
import org.springframework.cloud.kubernetes.ribbon.KubernetesServerList;

public class KubernetesEndpointsServerList
extends KubernetesServerList {
    private static final Log LOG = LogFactory.getLog(KubernetesEndpointsServerList.class);

    KubernetesEndpointsServerList(KubernetesClient client, KubernetesRibbonProperties properties) {
        super(client, properties);
    }

    public List<Server> getUpdatedListOfServers() {
        Endpoints endpoints;
        ArrayList<Server> result = new ArrayList<Server>();
        Endpoints endpoints2 = endpoints = StringUtils.isNotBlank((String)this.getNamespace()) ? (Endpoints)((Resource)((NonNamespaceOperation)this.getClient().endpoints().inNamespace(this.getNamespace())).withName(this.getServiceId())).get() : (Endpoints)((Resource)this.getClient().endpoints().withName(this.getServiceId())).get();
        if (endpoints != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Found [%d] endpoints in l [%s] for name [%s] and portName [%s]", endpoints.getSubsets().size(), endpoints.getMetadata().getNamespace(), this.getServiceId(), this.getPortName()));
            }
            for (EndpointSubset subset : endpoints.getSubsets()) {
                if (subset.getPorts().size() == 1) {
                    EndpointPort port = (EndpointPort)subset.getPorts().get(KubernetesEndpointsServerList.getFIRST());
                    for (EndpointAddress address : subset.getAddresses()) {
                        result.add(new Server(address.getIp(), port.getPort().intValue()));
                    }
                    continue;
                }
                for (EndpointPort port : subset.getPorts()) {
                    if (!Utils.isNullOrEmpty((String)this.getPortName()) && !this.getPortName().endsWith(port.getName())) continue;
                    for (EndpointAddress address : subset.getAddresses()) {
                        result.add(new Server(address.getIp(), port.getPort().intValue()));
                    }
                }
            }
        }
        if (result.isEmpty()) {
            LOG.warn((Object)String.format("Did not find any endpoints in ribbon in namespace [%s] for name [%s] and portName [%s]", this.getNamespace(), this.getServiceId(), this.getPortName()));
        }
        return result;
    }
}

