/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.loadbalancer;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.core.env.Environment;
import reactor.core.publisher.Flux;

public class KubernetesServicesListSupplier
implements ServiceInstanceListSupplier {
    private final Environment environment;
    private final KubernetesClient kubernetesClient;
    private final KubernetesDiscoveryProperties discoveryProperties;
    private final KubernetesServiceInstanceMapper mapper;

    KubernetesServicesListSupplier(Environment environment, KubernetesClient kubernetesClient, KubernetesServiceInstanceMapper mapper, KubernetesDiscoveryProperties discoveryProperties) {
        this.environment = environment;
        this.kubernetesClient = kubernetesClient;
        this.discoveryProperties = discoveryProperties;
        this.mapper = mapper;
    }

    public String getServiceId() {
        return this.environment.getProperty("loadbalancer.client.name");
    }

    public Flux<List<ServiceInstance>> get() {
        ArrayList<KubernetesServiceInstance> result = new ArrayList<KubernetesServiceInstance>();
        if (this.discoveryProperties.isAllNamespaces()) {
            List services = ((ServiceList)((FilterWatchListDeletable)((FilterWatchListMultiDeletable)this.kubernetesClient.services().inAnyNamespace()).withField("metadata.name", this.getServiceId())).list()).getItems();
            services.forEach(service -> result.add(this.mapper.map((Service)service)));
        } else {
            Service service2;
            Service service3 = service2 = StringUtils.isNotBlank((String)this.kubernetesClient.getNamespace()) ? (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.kubernetesClient.getNamespace())).withName(this.getServiceId())).get() : (Service)((ServiceResource)this.kubernetesClient.services().withName(this.getServiceId())).get();
            if (service2 != null) {
                result.add(this.mapper.map(service2));
            }
        }
        return Flux.defer(() -> Flux.just((Object)result));
    }
}

