/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.leader;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.leader.LeaderInfoContributor;
import org.springframework.cloud.kubernetes.leader.LeaderInitiator;
import org.springframework.cloud.kubernetes.leader.LeaderProperties;
import org.springframework.cloud.kubernetes.leader.LeaderRecordWatcher;
import org.springframework.cloud.kubernetes.leader.LeadershipController;
import org.springframework.cloud.kubernetes.leader.PodReadinessWatcher;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LeaderProperties.class})
@ConditionalOnBean(value={KubernetesClient.class})
@ConditionalOnProperty(value={"spring.cloud.kubernetes.leader.enabled"}, matchIfMissing=true)
public class LeaderAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LeaderEventPublisher.class})
    public LeaderEventPublisher defaultLeaderEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        return new DefaultLeaderEventPublisher(applicationEventPublisher);
    }

    @Bean
    public Candidate candidate(LeaderProperties leaderProperties) throws UnknownHostException {
        String id = Inet4Address.getLocalHost().getHostName();
        String role = leaderProperties.getRole();
        return new DefaultCandidate(id, role);
    }

    @Bean
    public LeadershipController leadershipController(Candidate candidate, LeaderProperties leaderProperties, LeaderEventPublisher leaderEventPublisher, KubernetesClient kubernetesClient) {
        return new LeadershipController(candidate, leaderProperties, leaderEventPublisher, kubernetesClient);
    }

    @Bean
    public LeaderRecordWatcher leaderRecordWatcher(LeaderProperties leaderProperties, LeadershipController leadershipController, KubernetesClient kubernetesClient) {
        return new LeaderRecordWatcher(leaderProperties, leadershipController, kubernetesClient);
    }

    @Bean
    public PodReadinessWatcher hostPodWatcher(Candidate candidate, KubernetesClient kubernetesClient, LeadershipController leadershipController) {
        return new PodReadinessWatcher(candidate.getId(), kubernetesClient, leadershipController);
    }

    @Bean(destroyMethod="stop")
    public LeaderInitiator leaderInitiator(LeaderProperties leaderProperties, LeadershipController leadershipController, LeaderRecordWatcher leaderRecordWatcher, PodReadinessWatcher hostPodWatcher) {
        return new LeaderInitiator(leaderProperties, leadershipController, leaderRecordWatcher, hostPodWatcher);
    }

    @Bean
    @ConditionalOnClass(value={InfoContributor.class})
    public LeaderInfoContributor leaderInfoContributor(LeadershipController leadershipController, Candidate candidate) {
        return new LeaderInfoContributor(leadershipController, candidate);
    }
}

