/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.DiscoveryServerUrlInvalidException;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.discovery.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

public class KubernetesReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private WebClient webClient;

    public KubernetesReactiveDiscoveryClient(WebClient.Builder webClientBuilder, KubernetesDiscoveryClientProperties properties) {
        if (!StringUtils.hasText((String)properties.getDiscoveryServerUrl())) {
            throw new DiscoveryServerUrlInvalidException();
        }
        this.webClient = webClientBuilder.baseUrl(properties.getDiscoveryServerUrl()).build();
    }

    public String description() {
        return "Reactive Kubernetes Discovery Client";
    }

    @Cacheable(value={"serviceinstances"})
    public Flux<ServiceInstance> getInstances(String serviceId) {
        return this.webClient.get().uri("/apps/" + serviceId, new Object[0]).exchangeToFlux(clientResponse -> clientResponse.bodyToFlux(KubernetesServiceInstance.class));
    }

    @Cacheable(value={"services"})
    public Flux<String> getServices() {
        return this.webClient.get().uri("/apps", new Object[0]).exchangeToFlux(clientResponse -> clientResponse.bodyToFlux(Service.class).map(service -> service.getName()));
    }
}

