/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.kubernetes.config.AbstractConfigProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.kubernetes.config")
public class ConfigMapConfigProperties
extends AbstractConfigProperties {
    private static final String TARGET = "Config Map";
    private boolean enableApi = true;
    private List<String> paths = new LinkedList<String>();
    private List<Source> sources = new LinkedList<Source>();

    public boolean isEnableApi() {
        return this.enableApi;
    }

    public void setEnableApi(boolean enableApi) {
        this.enableApi = enableApi;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public List<NormalizedSource> determineSources() {
        if (this.sources.isEmpty()) {
            return new ArrayList<NormalizedSource>(){
                {
                    this.add(new NormalizedSource(ConfigMapConfigProperties.this.name, ConfigMapConfigProperties.this.namespace));
                }
            };
        }
        return this.sources.stream().map(s -> s.normalize(this.name, this.namespace)).collect(Collectors.toList());
    }

    @Override
    public String getConfigurationTarget() {
        return TARGET;
    }

    static class NormalizedSource {
        private final String name;
        private final String namespace;

        public NormalizedSource(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public static class Source {
        private String name;
        private String namespace;

        public Source() {
        }

        public Source(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((Object)this.name) && StringUtils.isEmpty((Object)this.namespace);
        }

        public NormalizedSource normalize(String defaultName, String defaultNamespace) {
            String normalizedName = StringUtils.isEmpty((Object)this.name) ? defaultName : this.name;
            String normalizedNamespace = StringUtils.isEmpty((Object)this.namespace) ? defaultNamespace : this.namespace;
            return new NormalizedSource(normalizedName, normalizedNamespace);
        }
    }
}

