/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.config.AbstractConfigProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ConfigUtils {
    private static final Log LOG = LogFactory.getLog(ConfigUtils.class);

    public static <C extends AbstractConfigProperties> String getApplicationName(Environment env, C config) {
        String name = config.getName();
        if (StringUtils.isEmpty((Object)name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(config.getConfigurationTarget() + " name has not been set, taking it from property/env " + "spring.application.name" + " (default=" + "application" + ")"));
            }
            name = env.getProperty("spring.application.name", "application");
        }
        return name;
    }

    public static <C extends AbstractConfigProperties> String getApplicationNamespace(KubernetesClient client, Environment env, C config) {
        String namespace = config.getNamespace();
        if (StringUtils.isEmpty((Object)namespace)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(config.getConfigurationTarget() + " namespace has not been set, taking it from client (ns=" + client.getNamespace() + ")"));
            }
            namespace = client.getNamespace();
        }
        return namespace;
    }
}

