/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.PropertySourceUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;

public abstract class ConfigMapPropertySource
extends MapPropertySource {
    private static final Log LOG = LogFactory.getLog(ConfigMapPropertySource.class);
    protected static final String APPLICATION_YML = "application.yml";
    protected static final String APPLICATION_YAML = "application.yaml";
    protected static final String APPLICATION_PROPERTIES = "application.properties";
    protected static final String PREFIX = "configmap";

    public ConfigMapPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    protected static Environment createEnvironmentWithActiveProfiles(String[] activeProfiles) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.setActiveProfiles(activeProfiles);
        return environment;
    }

    protected static String getName(String name, String namespace) {
        return PREFIX + "." + name + "." + namespace;
    }

    protected static Map<String, Object> processAllEntries(Map<String, String> input, Environment environment) {
        Set<Map.Entry<String, String>> entrySet = input.entrySet();
        if (entrySet.size() == 1) {
            Map.Entry<String, String> singleEntry = entrySet.iterator().next();
            String propertyName = singleEntry.getKey();
            String propertyValue = singleEntry.getValue();
            if (propertyName.endsWith(".yml") || propertyName.endsWith(".yaml")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a yaml file"));
                }
                return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
            if (propertyName.endsWith(".properties")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a properties file"));
                }
                return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
            return ConfigMapPropertySource.defaultProcessAllEntries(input, environment);
        }
        return ConfigMapPropertySource.defaultProcessAllEntries(input, environment);
    }

    protected static Map<String, Object> defaultProcessAllEntries(Map<String, String> input, Environment environment) {
        return input.entrySet().stream().map(e -> ConfigMapPropertySource.extractProperties((String)e.getKey(), (String)e.getValue(), environment)).filter(m -> !m.isEmpty()).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, PropertySourceUtils.throwingMerger(), LinkedHashMap::new));
    }

    protected static Map<String, Object> extractProperties(final String resourceName, final String content, Environment environment) {
        if (resourceName.equals(APPLICATION_YAML) || resourceName.equals(APPLICATION_YML)) {
            return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
        }
        if (resourceName.equals(APPLICATION_PROPERTIES)) {
            return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
        }
        return new LinkedHashMap<String, Object>(){
            {
                this.put(resourceName, content);
            }
        };
    }

    protected static Map<String, Object> asObjectMap(Map<String, Object> source) {
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, PropertySourceUtils.throwingMerger(), LinkedHashMap::new));
    }
}

