/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.loadbalancer;

import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.DiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortNameAndNumber;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesLoadBalancerProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.StringUtils;

public class KubernetesClientServiceInstanceMapper
implements KubernetesServiceInstanceMapper<V1Service> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientServiceInstanceMapper.class));
    private static final Map<String, Integer> PORTS_DATA = Map.of();
    private final KubernetesLoadBalancerProperties properties;
    private final KubernetesDiscoveryProperties discoveryProperties;
    private final ServicePortSecureResolver resolver;

    public KubernetesClientServiceInstanceMapper(KubernetesLoadBalancerProperties properties, KubernetesDiscoveryProperties discoveryProperties) {
        this.properties = properties;
        this.discoveryProperties = discoveryProperties;
        this.resolver = new ServicePortSecureResolver(discoveryProperties);
    }

    public KubernetesServiceInstance map(V1Service service) {
        V1ServicePort port;
        V1ObjectMeta metadata = service.getMetadata();
        List ports = Optional.ofNullable(service.getSpec()).map(V1ServiceSpec::getPorts).orElse(List.of());
        if (ports.isEmpty()) {
            LOG.warn(() -> "service : " + metadata.getName() + " does not have any ServicePort(s), will not consider it for load balancing");
            return null;
        }
        if (ports.size() == 1) {
            LOG.debug(() -> "single ServicePort found, will use it as-is (without checking 'spring.cloud.kubernetes.loadbalancer.portName')");
            port = (V1ServicePort)ports.get(0);
        } else {
            String portNameFromProperties = this.properties.getPortName();
            if (StringUtils.hasText((String)portNameFromProperties)) {
                Optional<V1ServicePort> optionalPort = ports.stream().filter(x -> Objects.equals(x.getName(), portNameFromProperties)).findAny();
                if (optionalPort.isPresent()) {
                    LOG.debug(() -> "found port name that matches : " + portNameFromProperties);
                    port = optionalPort.get();
                } else {
                    this.logWarning(portNameFromProperties);
                    port = (V1ServicePort)ports.get(0);
                }
            } else {
                LOG.warn(() -> "'spring.cloud.kubernetes.loadbalancer.portName' is not set");
                LOG.warn(() -> "Will return 'first' port found, which is non-deterministic");
                port = (V1ServicePort)ports.get(0);
            }
        }
        String host = KubernetesServiceInstanceMapper.createHost((String)service.getMetadata().getName(), (String)service.getMetadata().getNamespace(), (String)this.properties.getClusterDomain());
        boolean secure = this.secure(port, service);
        return new DefaultKubernetesServiceInstance(metadata.getUid(), metadata.getName(), host, port.getPort().intValue(), this.serviceMetadata(service), secure);
    }

    private Map<String, String> serviceMetadata(V1Service service) {
        V1ObjectMeta metadata = service.getMetadata();
        V1ServiceSpec serviceSpec = service.getSpec();
        ServiceMetadata serviceMetadata = new ServiceMetadata(metadata.getName(), metadata.getNamespace(), serviceSpec.getType(), metadata.getLabels(), metadata.getAnnotations());
        return DiscoveryClientUtils.serviceInstanceMetadata(PORTS_DATA, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.discoveryProperties);
    }

    private boolean secure(V1ServicePort port, V1Service service) {
        V1ObjectMeta metadata = service.getMetadata();
        ServicePortNameAndNumber portNameAndNumber = new ServicePortNameAndNumber(port.getPort(), port.getName());
        ServicePortSecureResolver.Input input = new ServicePortSecureResolver.Input(portNameAndNumber, metadata.getName(), metadata.getLabels(), metadata.getAnnotations());
        return this.resolver.resolve(input);
    }

    private void logWarning(String portNameFromProperties) {
        LOG.warn(() -> "Did not find a port name that is equal to the value " + portNameFromProperties);
        LOG.warn(() -> "Will return 'first' port found, which is non-deterministic");
    }
}

