/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.loadbalancer;

import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.client.loadbalancer.KubernetesClientLoadBalancerClientConfiguration;
import org.springframework.cloud.kubernetes.client.loadbalancer.KubernetesClientServiceInstanceMapper;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesLoadBalancerProperties;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={KubernetesLoadBalancerProperties.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnProperty(value={"spring.cloud.kubernetes.loadbalancer.enabled"}, matchIfMissing=true)
@LoadBalancerClients(defaultConfiguration={KubernetesClientLoadBalancerClientConfiguration.class})
public class KubernetesClientLoadBalancerAutoConfiguration {
    @Bean
    KubernetesClientServiceInstanceMapper mapper(KubernetesLoadBalancerProperties properties, KubernetesDiscoveryProperties discoveryProperties) {
        return new KubernetesClientServiceInstanceMapper(properties, discoveryProperties);
    }
}

