/*
 * Copyright 2013-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;

import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.core.env.Environment;

/**
 * A context/holder for various data needed to compute property sources.
 *
 * @author wind57
 */
public record KubernetesClientConfigContext(CoreV1Api client, NormalizedSource normalizedSource, String namespace,
		Environment environment, boolean includeDefaultProfileData) {

	public KubernetesClientConfigContext(CoreV1Api client, NormalizedSource normalizedSource, String namespace,
			Environment environment) {
		this(client, normalizedSource, namespace, environment, true);
	}
}
