/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import java.util.EnumMap;
import java.util.Optional;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigContext;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientContextToSourceData;
import org.springframework.cloud.kubernetes.client.config.LabeledConfigMapContextToSourceDataProvider;
import org.springframework.cloud.kubernetes.client.config.NamedConfigMapContextToSourceDataProvider;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSourceType;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.cloud.kubernetes.commons.config.SourceDataEntriesProcessor;

public class KubernetesClientConfigMapPropertySource
extends SourceDataEntriesProcessor {
    private static final EnumMap<NormalizedSourceType, KubernetesClientContextToSourceData> STRATEGIES = new EnumMap(NormalizedSourceType.class);

    public KubernetesClientConfigMapPropertySource(KubernetesClientConfigContext context) {
        super(KubernetesClientConfigMapPropertySource.getSourceData(context));
    }

    private static SourceData getSourceData(KubernetesClientConfigContext context) {
        NormalizedSourceType type = context.normalizedSource().type();
        return Optional.ofNullable(STRATEGIES.get(type)).map(x -> (SourceData)x.apply(context)).orElseThrow(() -> new IllegalArgumentException("no strategy found for : " + type));
    }

    private static KubernetesClientContextToSourceData namedConfigMap() {
        return new NamedConfigMapContextToSourceDataProvider().get();
    }

    private static KubernetesClientContextToSourceData labeledConfigMap() {
        return new LabeledConfigMapContextToSourceDataProvider().get();
    }

    static {
        STRATEGIES.put(NormalizedSourceType.NAMED_CONFIG_MAP, KubernetesClientConfigMapPropertySource.namedConfigMap());
        STRATEGIES.put(NormalizedSourceType.LABELED_CONFIG_MAP, KubernetesClientConfigMapPropertySource.labeledConfigMap());
    }
}

