/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.NamespaceResolutionFailedException;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.util.StringUtils;

public final class KubernetesClientConfigUtils {
    private static final Log LOG = LogFactory.getLog(KubernetesClientConfigUtils.class);

    private KubernetesClientConfigUtils() {
    }

    @Deprecated
    public static String getNamespace(ConfigMapConfigProperties.NormalizedSource normalizedSource, KubernetesClientProperties kubernetesClientProperties) {
        if (!StringUtils.hasText((String)normalizedSource.getNamespace())) {
            return kubernetesClientProperties.getNamespace();
        }
        return normalizedSource.getNamespace();
    }

    @Deprecated
    public static String getNamespace(SecretsConfigProperties.NormalizedSource normalizedSource, KubernetesClientProperties kubernetesClientProperties) {
        if (!StringUtils.hasText((String)normalizedSource.getNamespace())) {
            return kubernetesClientProperties.getNamespace();
        }
        return normalizedSource.getNamespace();
    }

    @Deprecated
    public static String getNamespace(ConfigMapConfigProperties.NormalizedSource normalizedSource, String fallbackNamespace) {
        String normalizedNamespace = normalizedSource.getNamespace();
        return StringUtils.hasText((String)normalizedNamespace) ? normalizedNamespace : fallbackNamespace;
    }

    @Deprecated
    public static String getNamespace(SecretsConfigProperties.NormalizedSource normalizedSource, String fallbackNamespace) {
        String normalizedNamespace = normalizedSource.getNamespace();
        return StringUtils.hasText((String)normalizedNamespace) ? normalizedNamespace : fallbackNamespace;
    }

    static String getApplicationNamespace(String namespace, String configurationTarget, KubernetesNamespaceProvider provider) {
        String providerNamespace;
        if (StringUtils.hasText((String)namespace)) {
            LOG.debug((Object)(configurationTarget + " namespace from normalized source : " + namespace));
            return namespace;
        }
        if (provider != null && StringUtils.hasText((String)(providerNamespace = provider.getNamespace()))) {
            LOG.debug((Object)(configurationTarget + " namespace from provider : " + namespace));
            return providerNamespace;
        }
        throw new NamespaceResolutionFailedException("unresolved namespace");
    }
}

