/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Value;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public final class CommitTimestamp {
    private static final Map<Object, Object> VALUES = new ConcurrentHashMap<Object, Object>();

    private CommitTimestamp() {
    }

    public static <T> T of(Class<T> timestampClass) throws IllegalArgumentException {
        return (T)VALUES.computeIfAbsent(timestampClass, key -> {
            throw new IllegalArgumentException(String.format("\"CommitTimestamp\" is not supported for the type %s", key));
        });
    }

    private static <C> void register(C commitTimestamp) throws IllegalStateException {
        VALUES.compute(commitTimestamp.getClass(), (key, old) -> {
            if (old == null) {
                return commitTimestamp;
            }
            throw new IllegalStateException(String.format("The value %s already registered as \"CommitTimestamp\" for the type %s", old, key));
        });
    }

    static {
        VALUES.put(Timestamp.class, Value.COMMIT_TIMESTAMP);
    }

    public static abstract class CommitTimestampDecorator<S>
    implements Converter<S, Timestamp> {
        final S commitTimestamp;
        private final Function<S, Timestamp> converter;

        protected CommitTimestampDecorator(S commitTimestamp, Function<S, Timestamp> converter) {
            this.commitTimestamp = commitTimestamp;
            this.converter = converter;
            CommitTimestamp.register(commitTimestamp);
        }

        @Nullable
        public final Timestamp convert(@NonNull S source) {
            return this.commitTimestamp == source ? Value.COMMIT_TIMESTAMP : this.converter.apply(source);
        }
    }
}

