/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.ValueBinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.cloud.gcp.data.spanner.core.SpannerPageableQueryOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConverterAwareMappingSpannerEntityWriter;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerCustomConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Pair;

public final class SpannerStatementQueryExecutor {
    private SpannerStatementQueryExecutor() {
    }

    public static <T> List<T> executeQuery(Class<T> type, PartTree tree, Object[] params, SpannerTemplate spannerTemplate, SpannerMappingContext spannerMappingContext) {
        Pair<String, List<String>> sqlAndTags = SpannerStatementQueryExecutor.buildPartTreeSqlString(tree, spannerMappingContext, type);
        return spannerTemplate.query(type, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs((String)sqlAndTags.getFirst(), (List)sqlAndTags.getSecond(), null, spannerTemplate.getSpannerEntityProcessor().getWriteConverter(), params), null);
    }

    public static <A, T> List<A> executeQuery(Function<Struct, A> rowFunc, Class<T> type, PartTree tree, Object[] params, SpannerTemplate spannerTemplate, SpannerMappingContext spannerMappingContext) {
        Pair<String, List<String>> sqlAndTags = SpannerStatementQueryExecutor.buildPartTreeSqlString(tree, spannerMappingContext, type);
        return spannerTemplate.query(rowFunc, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs((String)sqlAndTags.getFirst(), (List)sqlAndTags.getSecond(), null, spannerTemplate.getSpannerEntityProcessor().getWriteConverter(), params), null);
    }

    public static <T> String applySortingPagingQueryOptions(Class<T> entityClass, SpannerPageableQueryOptions options, String sql, SpannerMappingContext mappingContext) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)mappingContext.getPersistentEntity(entityClass);
        StringBuilder sb = SpannerStatementQueryExecutor.applySort(options.getSort(), new StringBuilder("SELECT * FROM (").append(sql).append(")"), o -> {
            SpannerPersistentProperty property = (SpannerPersistentProperty)persistentEntity.getPersistentProperty(o.getProperty());
            return property != null ? property.getColumnName() : o.getProperty();
        });
        if (options.getLimit() != null) {
            sb.append(" LIMIT ").append(options.getLimit());
        }
        if (options.getOffset() != null) {
            sb.append(" OFFSET ").append(options.getOffset());
        }
        return sb.toString();
    }

    public static <T> Statement getChildrenRowsQuery(Key parentKey, SpannerPersistentEntity<T> childPersistentEntity) {
        StringBuilder sb = new StringBuilder("SELECT " + SpannerStatementQueryExecutor.getColumnsStringForSelect(childPersistentEntity) + " FROM " + childPersistentEntity.tableName() + " WHERE ");
        StringJoiner sj = new StringJoiner(" and ");
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList keyParts = new ArrayList();
        int tagNum = 0;
        List<SpannerPersistentProperty> childKeyProperties = childPersistentEntity.getFlattenedPrimaryKeyProperties();
        Iterator parentKeyParts = parentKey.getParts().iterator();
        while (parentKeyParts.hasNext()) {
            SpannerPersistentProperty keyProp = childKeyProperties.get(tagNum);
            String tagName = "tag" + tagNum;
            sj.add(keyProp.getColumnName() + " = @" + tagName);
            tags.add(tagName);
            keyParts.add(parentKeyParts.next());
            ++tagNum;
        }
        return SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(sb.toString() + sj.toString(), tags, null, null, keyParts.toArray());
    }

    public static Statement buildStatementFromSqlWithArgs(String sql, List<String> tags, Function<Object, Struct> paramStructConvertFunc, SpannerCustomConverter spannerCustomConverter, Object[] params) {
        if (tags == null && params == null) {
            return Statement.of((String)sql);
        }
        if (tags == null || params == null || tags.size() != params.length) {
            throw new IllegalArgumentException("The number of tags does match the number of params.");
        }
        Statement.Builder builder = Statement.newBuilder((String)sql);
        for (int i = 0; i < tags.size(); ++i) {
            SpannerStatementQueryExecutor.bindParameter((ValueBinder<Statement.Builder>)builder.bind(tags.get(i)), paramStructConvertFunc, spannerCustomConverter, params[i]);
        }
        return builder.build();
    }

    private static void bindParameter(ValueBinder<Statement.Builder> bind, Function<Object, Struct> paramStructConvertFunc, SpannerCustomConverter spannerCustomConverter, Object originalParam) {
        Class<?> compatible;
        Object param = originalParam;
        BiFunction<ValueBinder, ?, ?> toMethod = SpannerStatementQueryExecutor.getValueBinderBiFunction(param);
        if (toMethod == null && spannerCustomConverter != null && (compatible = ConverterAwareMappingSpannerEntityWriter.findFirstCompatibleSpannerSingleItemNativeType(type -> spannerCustomConverter.canConvert(originalParam.getClass(), (Class<?>)type))) != null) {
            param = spannerCustomConverter.convert(originalParam, compatible);
            toMethod = SpannerStatementQueryExecutor.getValueBinderBiFunction(param);
        }
        if (toMethod == null) {
            if (paramStructConvertFunc == null) {
                throw new IllegalArgumentException("Param: " + param.toString() + " is not a supported type: " + param.getClass());
            }
            try {
                toMethod = ConverterAwareMappingSpannerEntityWriter.singleItemTypeValueBinderMethodMap.get(Struct.class);
                param = paramStructConvertFunc.apply(param);
            }
            catch (SpannerDataException ex) {
                throw new IllegalArgumentException("Param: " + param.toString() + " is not a supported type: " + param.getClass(), (Throwable)((Object)ex));
            }
        }
        Object unused = toMethod.apply(bind, param);
    }

    public static String getColumnsStringForSelect(SpannerPersistentEntity spannerPersistentEntity) {
        return String.join((CharSequence)" , ", spannerPersistentEntity.columns());
    }

    private static BiFunction<ValueBinder, ?, ?> getValueBinderBiFunction(Object param) {
        if (Struct.class.isAssignableFrom(param.getClass())) {
            return ConverterAwareMappingSpannerEntityWriter.singleItemTypeValueBinderMethodMap.get(Struct.class);
        }
        if (param.getClass().isEnum()) {
            return (binder, value) -> ConverterAwareMappingSpannerEntityWriter.singleItemTypeValueBinderMethodMap.get(String.class).apply((ValueBinder)binder, value.toString());
        }
        return ConverterAwareMappingSpannerEntityWriter.singleItemTypeValueBinderMethodMap.get(param.getClass());
    }

    private static Pair<String, List<String>> buildPartTreeSqlString(PartTree tree, SpannerMappingContext spannerMappingContext, Class type) {
        String selectSql;
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)spannerMappingContext.getPersistentEntity(type);
        ArrayList<String> tags = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        SpannerStatementQueryExecutor.buildSelect(persistentEntity, tree, stringBuilder);
        SpannerStatementQueryExecutor.buildFrom(persistentEntity, stringBuilder);
        SpannerStatementQueryExecutor.buildWhere(tree, persistentEntity, tags, stringBuilder);
        SpannerStatementQueryExecutor.applySort(tree.getSort(), stringBuilder, o -> ((SpannerPersistentProperty)persistentEntity.getPersistentProperty(o.getProperty())).getColumnName());
        SpannerStatementQueryExecutor.buildLimit(tree, stringBuilder);
        String finalSql = selectSql = stringBuilder.toString();
        if (tree.isCountProjection()) {
            finalSql = "SELECT COUNT(1) FROM (" + selectSql + ")";
        } else if (tree.isExistsProjection()) {
            finalSql = "SELECT EXISTS(" + selectSql + ")";
        }
        return Pair.of((Object)finalSql, tags);
    }

    private static StringBuilder buildSelect(SpannerPersistentEntity spannerPersistentEntity, PartTree tree, StringBuilder stringBuilder) {
        stringBuilder.append("SELECT " + (tree.isDistinct() ? "DISTINCT " : "") + SpannerStatementQueryExecutor.getColumnsStringForSelect(spannerPersistentEntity) + " ");
        return stringBuilder;
    }

    private static void buildFrom(SpannerPersistentEntity<?> persistentEntity, StringBuilder stringBuilder) {
        stringBuilder.append("FROM " + persistentEntity.tableName() + " ");
    }

    public static StringBuilder applySort(Sort sort, StringBuilder sql, Function<Sort.Order, String> sortedPropertyNameFunction) {
        if (sort == null || sort.isUnsorted()) {
            return sql;
        }
        sql.append(" ORDER BY ");
        StringJoiner sj = new StringJoiner(" , ");
        sort.iterator().forEachRemaining(o -> {
            String sortedPropertyName = (String)sortedPropertyNameFunction.apply((Sort.Order)o);
            String sortedProperty = o.isIgnoreCase() ? "LOWER(" + sortedPropertyName + ")" : sortedPropertyName;
            sj.add(sortedProperty + (o.isAscending() ? " ASC" : " DESC"));
        });
        return sql.append(sj);
    }

    private static void buildWhere(PartTree tree, SpannerPersistentEntity<?> persistentEntity, List<String> tags, StringBuilder stringBuilder) {
        if (tree.hasPredicate()) {
            stringBuilder.append("WHERE ");
            StringJoiner orStrings = new StringJoiner(" OR ");
            tree.iterator().forEachRemaining(orPart -> {
                String orString = "( ";
                StringJoiner andStrings = new StringJoiner(" AND ");
                orPart.forEach(part -> {
                    String segment = part.getProperty().getSegment();
                    String tag = "tag" + tags.size();
                    tags.add(tag);
                    SpannerPersistentProperty spannerPersistentProperty = (SpannerPersistentProperty)persistentEntity.getPersistentProperty(segment);
                    if (spannerPersistentProperty.isEmbedded()) {
                        throw new SpannerDataException("Embedded class properties are not currently supported in query method names: " + segment);
                    }
                    String andString = spannerPersistentProperty.getColumnName();
                    String insertedTag = "@" + tag;
                    if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) {
                        andString = "LOWER(" + andString + ")";
                        insertedTag = "LOWER(" + insertedTag + ")";
                    } else if (part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER) {
                        throw new SpannerDataException("Only ignore-case types ALWAYS and NEVER are supported, because the underlying table schema is not retrieved at query time to check that the column is the STRING or BYTES Cloud Spanner  type supported for ignoring case.");
                    }
                    switch (part.getType()) {
                        case LIKE: {
                            andString = andString + " LIKE " + insertedTag;
                            break;
                        }
                        case NOT_LIKE: {
                            andString = andString + " NOT LIKE " + insertedTag;
                            break;
                        }
                        case CONTAINING: {
                            andString = " REGEXP_CONTAINS(" + andString + "," + insertedTag + ") =TRUE";
                            break;
                        }
                        case NOT_CONTAINING: {
                            andString = " REGEXP_CONTAINS(" + andString + "," + insertedTag + ") =FALSE";
                            break;
                        }
                        case SIMPLE_PROPERTY: {
                            andString = andString + "=" + insertedTag;
                            break;
                        }
                        case TRUE: {
                            andString = andString + "=TRUE";
                            break;
                        }
                        case FALSE: {
                            andString = andString + "=FALSE";
                            break;
                        }
                        case IS_NULL: {
                            andString = andString + "=NULL";
                            break;
                        }
                        case LESS_THAN: {
                            andString = andString + "<" + insertedTag;
                            break;
                        }
                        case IS_NOT_NULL: {
                            andString = andString + "<>NULL";
                            break;
                        }
                        case LESS_THAN_EQUAL: {
                            andString = andString + "<=" + insertedTag;
                            break;
                        }
                        case GREATER_THAN: {
                            andString = andString + ">" + insertedTag;
                            break;
                        }
                        case GREATER_THAN_EQUAL: {
                            andString = andString + ">=" + insertedTag;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("The statement type: " + part.getType() + " is not supported.");
                        }
                    }
                    andStrings.add(andString);
                });
                orString = orString + andStrings.toString();
                orString = orString + " )";
                orStrings.add(orString);
            });
            stringBuilder.append(orStrings.toString());
        }
    }

    private static void buildLimit(PartTree tree, StringBuilder stringBuilder) {
        if (tree.isExistsProjection()) {
            stringBuilder.append(" LIMIT 1");
        } else if (tree.isLimiting()) {
            stringBuilder.append(" LIMIT " + tree.getMaxResults());
        }
    }
}

