/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.secretmanager;

import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceClient;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.gcp.autoconfigure.secretmanager.SecretManagerPropertySource;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class SecretManagerPropertySourceLocator
implements PropertySourceLocator {
    private static final String SECRET_MANAGER_NAME = "spring-cloud-gcp-secret-manager";
    private final SecretManagerServiceClient client;
    private final GcpProjectIdProvider projectIdProvider;
    private final String secretsPrefix;

    SecretManagerPropertySourceLocator(SecretManagerServiceClient client, GcpProjectIdProvider projectIdProvider, String secretsPrefix) {
        this.client = client;
        this.projectIdProvider = projectIdProvider;
        this.secretsPrefix = secretsPrefix;
    }

    public PropertySource<?> locate(Environment environment) {
        return new SecretManagerPropertySource(SECRET_MANAGER_NAME, this.client, this.projectIdProvider, this.secretsPrefix);
    }
}

