/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.pubsub;

import java.util.Optional;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.gcp.autoconfigure.pubsub.GcpPubSubAutoConfiguration;
import org.springframework.cloud.gcp.pubsub.core.subscriber.PubSubSubscriberOperations;
import org.springframework.cloud.gcp.pubsub.core.subscriber.PubSubSubscriberTemplate;
import org.springframework.cloud.gcp.pubsub.reactive.PubSubReactiveFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Configuration
@AutoConfigureAfter(value={GcpPubSubAutoConfiguration.class})
@ConditionalOnClass(value={Flux.class, PubSubSubscriberTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.reactive.enabled", "spring.cloud.gcp.pubsub.enabled"}, matchIfMissing=true)
public class GcpPubSubReactiveAutoConfiguration {
    private Scheduler defaultPubSubReactiveScheduler;

    @Bean
    @ConditionalOnMissingBean
    public PubSubReactiveFactory pubSubReactiveFactory(PubSubSubscriberTemplate subscriberTemplate, @Qualifier(value="pubSubReactiveScheduler") Optional<Scheduler> userProvidedScheduler) {
        Scheduler scheduler = null;
        scheduler = userProvidedScheduler.isPresent() ? userProvidedScheduler.get() : (this.defaultPubSubReactiveScheduler = Schedulers.newElastic((String)"pubSubReactiveScheduler"));
        return new PubSubReactiveFactory((PubSubSubscriberOperations)subscriberTemplate, scheduler);
    }

    @PreDestroy
    public void closeScheduler() {
        if (this.defaultPubSubReactiveScheduler != null) {
            this.defaultPubSubReactiveScheduler.dispose();
        }
    }
}

