/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.datastore;

import com.google.cloud.datastore.Datastore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTransactionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnClass(value={DatastoreTransactionManager.class})
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
public class DatastoreTransactionManagerAutoConfiguration {

    @Configuration
    static class DatastoreTransactionManagerConfiguration {
        private final Datastore datastore;
        private final TransactionManagerCustomizers transactionManagerCustomizers;

        DatastoreTransactionManagerConfiguration(Datastore datastore, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            this.datastore = datastore;
            this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
        public DatastoreTransactionManager datastoreTransactionManager() {
            DatastoreTransactionManager transactionManager = new DatastoreTransactionManager(this.datastore);
            if (this.transactionManagerCustomizers != null) {
                this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
            }
            return transactionManager;
        }
    }
}

