/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledFilter;
import org.springframework.cloud.gateway.filter.factory.cache.GlobalLocalResponseCacheGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheProperties;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheUtils;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManagerFactory;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.CacheKeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LocalResponseCacheProperties.class})
@ConditionalOnClass(value={Weigher.class, Caffeine.class, CaffeineCacheManager.class})
@ConditionalOnEnabledFilter(value=LocalResponseCacheGatewayFilterFactory.class)
public class LocalResponseCacheAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(LocalResponseCacheAutoConfiguration.class);
    private static final String RESPONSE_CACHE_NAME = "response-cache";
    static final String RESPONSE_CACHE_MANAGER_NAME = "gatewayCacheManager";

    @Bean
    @Conditional(value={OnGlobalLocalResponseCacheCondition.class})
    public GlobalLocalResponseCacheGatewayFilter globalLocalResponseCacheGatewayFilter(ResponseCacheManagerFactory responseCacheManagerFactory, @Qualifier(value="gatewayCacheManager") CacheManager cacheManager, LocalResponseCacheProperties properties) {
        return new GlobalLocalResponseCacheGatewayFilter(responseCacheManagerFactory, this.responseCache(cacheManager), properties.getTimeToLive(), properties.getRequest());
    }

    @Bean(name={"gatewayCacheManager"})
    @Conditional(value={OnGlobalLocalResponseCacheCondition.class})
    public CacheManager gatewayCacheManager(LocalResponseCacheProperties cacheProperties) {
        return LocalResponseCacheUtils.createGatewayCacheManager(cacheProperties);
    }

    @Bean
    public LocalResponseCacheGatewayFilterFactory localResponseCacheGatewayFilterFactory(ResponseCacheManagerFactory responseCacheManagerFactory, LocalResponseCacheProperties properties) {
        return new LocalResponseCacheGatewayFilterFactory(responseCacheManagerFactory, properties.getTimeToLive(), properties.getSize(), properties.getRequest());
    }

    @Bean
    public ResponseCacheManagerFactory responseCacheManagerFactory(CacheKeyGenerator cacheKeyGenerator) {
        return new ResponseCacheManagerFactory(cacheKeyGenerator);
    }

    @Bean
    public CacheKeyGenerator cacheKeyGenerator() {
        return new CacheKeyGenerator();
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public static CaffeineCacheManager createGatewayCacheManager(LocalResponseCacheProperties cacheProperties) {
        return LocalResponseCacheUtils.createGatewayCacheManager(cacheProperties);
    }

    Cache responseCache(CacheManager cacheManager) {
        return cacheManager.getCache(RESPONSE_CACHE_NAME);
    }

    public static class OnGlobalLocalResponseCacheCondition
    extends AllNestedConditions {
        OnGlobalLocalResponseCacheCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.global-filter.local-response-cache.enabled"}, havingValue="true", matchIfMissing=true)
        static class OnGlobalLocalResponseCachePropertyEnabled {
            OnGlobalLocalResponseCachePropertyEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.gateway.server.webflux.filter.local-response-cache.enabled"}, havingValue="true")
        static class OnLocalResponseCachePropertyEnabled {
            OnLocalResponseCachePropertyEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.gateway.server.webflux.enabled"}, havingValue="true", matchIfMissing=true)
        static class OnGatewayPropertyEnabled {
            OnGatewayPropertyEnabled() {
            }
        }
    }
}

