/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Predicate;
import org.springframework.cloud.gateway.support.HasConfig;
import org.springframework.cloud.gateway.support.Visitor;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;

public interface GatewayPredicate
extends Predicate<ServerWebExchange>,
HasConfig {
    @Override
    default public Predicate<ServerWebExchange> and(Predicate<? super ServerWebExchange> other) {
        return new AndGatewayPredicate(this, GatewayPredicate.wrapIfNeeded(other));
    }

    @Override
    default public Predicate<ServerWebExchange> negate() {
        return new NegateGatewayPredicate(this);
    }

    @Override
    default public Predicate<ServerWebExchange> or(Predicate<? super ServerWebExchange> other) {
        return new OrGatewayPredicate(this, GatewayPredicate.wrapIfNeeded(other));
    }

    default public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public static GatewayPredicate wrapIfNeeded(Predicate<? super ServerWebExchange> other) {
        GatewayPredicate gatewayPredicate;
        GatewayPredicate right = other instanceof GatewayPredicate ? (gatewayPredicate = (GatewayPredicate)other) : new GatewayPredicateWrapper(other);
        return right;
    }

    public static class AndGatewayPredicate
    implements GatewayPredicate {
        private final GatewayPredicate left;
        private final GatewayPredicate right;

        public AndGatewayPredicate(GatewayPredicate left, GatewayPredicate right) {
            Assert.notNull((Object)left, (String)"Left GatewayPredicate must not be null");
            Assert.notNull((Object)right, (String)"Right GatewayPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(ServerWebExchange t) {
            return this.left.test(t) && this.right.test(t);
        }

        @Override
        public void accept(Visitor visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        public String toString() {
            return String.format("(%s && %s)", this.left, this.right);
        }
    }

    public static class NegateGatewayPredicate
    implements GatewayPredicate {
        private final GatewayPredicate predicate;

        public NegateGatewayPredicate(GatewayPredicate predicate) {
            Assert.notNull((Object)predicate, (String)"predicate GatewayPredicate must not be null");
            this.predicate = predicate;
        }

        @Override
        public boolean test(ServerWebExchange t) {
            return !this.predicate.test(t);
        }

        @Override
        public void accept(Visitor visitor) {
            this.predicate.accept(visitor);
        }

        public String toString() {
            return String.format("!%s", this.predicate);
        }
    }

    public static class OrGatewayPredicate
    implements GatewayPredicate {
        private final GatewayPredicate left;
        private final GatewayPredicate right;

        public OrGatewayPredicate(GatewayPredicate left, GatewayPredicate right) {
            Assert.notNull((Object)left, (String)"Left GatewayPredicate must not be null");
            Assert.notNull((Object)right, (String)"Right GatewayPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(ServerWebExchange t) {
            return this.left.test(t) || this.right.test(t);
        }

        @Override
        public void accept(Visitor visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        public String toString() {
            return String.format("(%s || %s)", this.left, this.right);
        }
    }

    public static class GatewayPredicateWrapper
    implements GatewayPredicate {
        private final Predicate<? super ServerWebExchange> delegate;

        public GatewayPredicateWrapper(Predicate<? super ServerWebExchange> delegate) {
            Assert.notNull(delegate, (String)"delegate GatewayPredicate must not be null");
            this.delegate = delegate;
        }

        @Override
        public boolean test(ServerWebExchange exchange) {
            return this.delegate.test((ServerWebExchange)exchange);
        }

        @Override
        public void accept(Visitor visitor) {
            Predicate<? super ServerWebExchange> predicate = this.delegate;
            if (predicate instanceof GatewayPredicate) {
                GatewayPredicate gatewayPredicate = (GatewayPredicate)predicate;
                gatewayPredicate.accept(visitor);
            }
        }

        public String toString() {
            return this.delegate.getClass().getSimpleName();
        }
    }
}

