/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.TrustedProxies;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class ForwardedHeadersFilter
implements HttpHeadersFilter,
Ordered {
    private static final Log log = LogFactory.getLog(ForwardedHeadersFilter.class);
    private Integer serverPort;
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean forwardedByEnabled = false;
    public static final String FORWARDED_HEADER = "Forwarded";
    private final TrustedProxies trustedProxies;

    @Deprecated
    public ForwardedHeadersFilter() {
        this.trustedProxies = s -> true;
        log.warn((Object)"spring.cloud.gateway.server.webflux.trusted-proxies is not set. Using deprecated Constructor. Untrusted hosts might be added to Forwarded header.");
    }

    public ForwardedHeadersFilter(String trustedProxiesRegex) {
        this.trustedProxies = TrustedProxies.from(trustedProxiesRegex);
    }

    static List<Forwarded> parse(List<String> values) {
        ArrayList<Forwarded> forwardeds = new ArrayList<Forwarded>();
        if (CollectionUtils.isEmpty(values)) {
            return forwardeds;
        }
        for (String value : values) {
            String[] forwardedValues;
            for (String forwardedValue : forwardedValues = StringUtils.tokenizeToStringArray((String)value, (String)",")) {
                Forwarded forwarded = ForwardedHeadersFilter.parse(forwardedValue);
                forwardeds.add(forwarded);
            }
        }
        return forwardeds;
    }

    static Forwarded parse(String value) {
        String[] pairs = StringUtils.tokenizeToStringArray((String)value, (String)";");
        LinkedCaseInsensitiveMap<String> result = ForwardedHeadersFilter.splitIntoCaseInsensitiveMap(pairs);
        if (result == null) {
            return null;
        }
        Forwarded forwarded = new Forwarded((Map<String, String>)result);
        return forwarded;
    }

    static LinkedCaseInsensitiveMap<String> splitIntoCaseInsensitiveMap(String[] pairs) {
        if (ObjectUtils.isEmpty((Object[])pairs)) {
            return null;
        }
        LinkedCaseInsensitiveMap result = new LinkedCaseInsensitiveMap();
        for (String element : pairs) {
            String[] splittedElement = StringUtils.split((String)element, (String)"=");
            if (splittedElement == null) continue;
            result.put(splittedElement[0].trim(), (Object)splittedElement[1].trim());
        }
        return result;
    }

    public void setForwardedByEnabled(boolean forwardedByEnabled) {
        this.forwardedByEnabled = forwardedByEnabled;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        if (request.getRemoteAddress() != null && !this.trustedProxies.isTrusted(request.getRemoteAddress().getHostString())) {
            log.trace((Object)LogMessage.format((String)"Remote address not trusted. pattern %s remote address %s", (Object)this.trustedProxies, (Object)request.getRemoteAddress()));
            return input;
        }
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        for (Object entry : original.headerSet()) {
            if (((String)entry.getKey()).equalsIgnoreCase(FORWARDED_HEADER)) continue;
            updated.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        List<Forwarded> forwardeds = ForwardedHeadersFilter.parse(original.get((Object)FORWARDED_HEADER));
        for (Forwarded f : forwardeds) {
            if (!this.trustedProxies.isTrusted(f.get("for"))) continue;
            updated.add(FORWARDED_HEADER, f.toHeaderValue());
        }
        URI uri = request.getURI();
        String host = original.getFirst("Host");
        Forwarded forwarded = new Forwarded().put("host", host).put("proto", uri.getScheme());
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        if (remoteAddress != null) {
            Object forValue;
            if (remoteAddress.isUnresolved()) {
                forValue = remoteAddress.getHostName();
            } else {
                InetAddress address = remoteAddress.getAddress();
                forValue = remoteAddress.getAddress().getHostAddress();
                if (address instanceof Inet6Address) {
                    forValue = "[" + (String)forValue + "]";
                }
            }
            if (this.trustedProxies.isTrusted((String)forValue)) {
                int port = remoteAddress.getPort();
                if (port >= 0) {
                    forValue = (String)forValue + ":" + port;
                }
                forwarded.put("for", (String)forValue);
            }
        }
        if (this.forwardedByEnabled) {
            this.addForwardedByHeader(forwarded);
        }
        updated.add(FORWARDED_HEADER, forwarded.toHeaderValue());
        return updated;
    }

    private void addForwardedByHeader(Forwarded forwarded) {
        try {
            this.addForwardedBy(forwarded, InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Can not resolve host address, skipping Forwarded 'by' header", (Throwable)e);
        }
    }

    void addForwardedBy(Forwarded forwarded, InetAddress localAddress) {
        if (localAddress != null) {
            Object byValue = localAddress.getHostAddress();
            if (localAddress instanceof Inet6Address) {
                byValue = "[" + (String)byValue + "]";
            }
            if (this.serverPort != null && this.serverPort > 0) {
                byValue = (String)byValue + ":" + this.serverPort;
            }
            forwarded.put("by", (String)byValue);
        }
    }

    static class Forwarded {
        private static final char EQUALS = '=';
        private static final char SEMICOLON = ';';
        private final Map<String, String> values;

        Forwarded() {
            this.values = new HashMap<String, String>();
        }

        Forwarded(Map<String, String> values) {
            this.values = values;
        }

        public Forwarded put(String key, String value) {
            this.values.put(key, this.quoteIfNeeded(value));
            return this;
        }

        private String quoteIfNeeded(String s) {
            if (s != null && s.contains(":")) {
                return "\"" + s + "\"";
            }
            return s;
        }

        public String get(String key) {
            return this.values.get(key);
        }

        Map<String, String> getValues() {
            return this.values;
        }

        public String toString() {
            return "Forwarded{values=" + this.values + "}";
        }

        public String toHeaderValue() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(';');
                }
                builder.append(entry.getKey()).append('=').append(entry.getValue());
            }
            return builder.toString();
        }
    }
}

