/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.observation.Observation;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.log.LogAccessor;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

public class ObservationClosingWebExceptionHandler
implements WebExceptionHandler {
    private static final LogAccessor log = new LogAccessor(ObservationClosingWebExceptionHandler.class);

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        Observation observation;
        Object attribute = exchange.getAttribute("gateway.observation.stopped");
        if (attribute == null && (observation = (Observation)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_OBSERVATION_ATTR)) != null) {
            if (log.isDebugEnabled()) {
                observation.scoped(() -> log.debug(() -> "An exception occurred and observation was not previously stopped, will stop it. The exception was [" + ex + "]"));
            }
            observation.error(ex);
            observation.stop();
        }
        return Mono.error((Throwable)ex);
    }
}

