/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.TrustedProxies;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

@ConfigurationProperties(value="spring.cloud.gateway.x-forwarded")
public class XForwardedHeadersFilter
implements HttpHeadersFilter,
Ordered {
    private static final Log log = LogFactory.getLog(XForwardedHeadersFilter.class);
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    public static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    public static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    public static final String X_FORWARDED_PREFIX_HEADER = "X-Forwarded-Prefix";
    private int order = 0;
    private boolean enabled = true;
    private boolean forEnabled = true;
    private boolean hostEnabled = true;
    private boolean portEnabled = true;
    private boolean protoEnabled = true;
    private boolean prefixEnabled = true;
    private boolean forAppend = true;
    private boolean hostAppend = true;
    private boolean portAppend = true;
    private boolean protoAppend = true;
    private boolean prefixAppend = true;
    private final TrustedProxies trustedProxies;

    @Deprecated
    public XForwardedHeadersFilter() {
        this.trustedProxies = s -> true;
        log.warn((Object)"spring.cloud.gateway.trusted-proxies is not set. Using deprecated Constructor. Untrusted hosts might be added to Forwarded header.");
    }

    public XForwardedHeadersFilter(String trustedProxiesRegex) {
        this.trustedProxies = TrustedProxies.from(trustedProxiesRegex);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isForEnabled() {
        return this.forEnabled;
    }

    public void setForEnabled(boolean forEnabled) {
        this.forEnabled = forEnabled;
    }

    public boolean isHostEnabled() {
        return this.hostEnabled;
    }

    public void setHostEnabled(boolean hostEnabled) {
        this.hostEnabled = hostEnabled;
    }

    public boolean isPortEnabled() {
        return this.portEnabled;
    }

    public void setPortEnabled(boolean portEnabled) {
        this.portEnabled = portEnabled;
    }

    public boolean isProtoEnabled() {
        return this.protoEnabled;
    }

    public void setProtoEnabled(boolean protoEnabled) {
        this.protoEnabled = protoEnabled;
    }

    public boolean isPrefixEnabled() {
        return this.prefixEnabled;
    }

    public void setPrefixEnabled(boolean prefixEnabled) {
        this.prefixEnabled = prefixEnabled;
    }

    public boolean isForAppend() {
        return this.forAppend;
    }

    public void setForAppend(boolean forAppend) {
        this.forAppend = forAppend;
    }

    public boolean isHostAppend() {
        return this.hostAppend;
    }

    public void setHostAppend(boolean hostAppend) {
        this.hostAppend = hostAppend;
    }

    public boolean isPortAppend() {
        return this.portAppend;
    }

    public void setPortAppend(boolean portAppend) {
        this.portAppend = portAppend;
    }

    public boolean isProtoAppend() {
        return this.protoAppend;
    }

    public void setProtoAppend(boolean protoAppend) {
        this.protoAppend = protoAppend;
    }

    public boolean isPrefixAppend() {
        return this.prefixAppend;
    }

    public void setPrefixAppend(boolean prefixAppend) {
        this.prefixAppend = prefixAppend;
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        if (request.getRemoteAddress() != null && !this.trustedProxies.isTrusted(request.getRemoteAddress().getHostString())) {
            log.trace((Object)LogMessage.format((String)"Remote address not trusted. pattern %s remote address %s", (Object)this.trustedProxies, (Object)request.getRemoteAddress()));
            return input;
        }
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        for (Map.Entry entry : original.headerSet()) {
            updated.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        if (this.isForEnabled()) {
            String remoteAddr = null;
            if (request.getRemoteAddress() != null && request.getRemoteAddress().getAddress() != null) {
                remoteAddr = request.getRemoteAddress().getHostString();
            }
            this.write(updated, X_FORWARDED_FOR_HEADER, remoteAddr, this.isForAppend(), this.trustedProxies::isTrusted);
        }
        String proto = request.getURI().getScheme();
        if (this.isProtoEnabled()) {
            this.write(updated, X_FORWARDED_PROTO_HEADER, proto, this.isProtoAppend());
        }
        if (this.isPrefixEnabled()) {
            LinkedHashSet originalUris = (LinkedHashSet)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
            URI requestUri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
            if (originalUris != null && requestUri != null) {
                originalUris.forEach(originalUri -> {
                    if (originalUri != null && originalUri.getPath() != null) {
                        String prefix = originalUri.getPath();
                        String originalUriPath = this.stripTrailingSlash((URI)originalUri);
                        String requestUriPath = this.stripTrailingSlash(requestUri);
                        this.updateRequest(updated, (URI)originalUri, originalUriPath, requestUriPath);
                    }
                });
            }
        }
        if (this.isPortEnabled()) {
            String port = String.valueOf(request.getURI().getPort());
            if (request.getURI().getPort() < 0) {
                port = String.valueOf(this.getDefaultPort(proto));
            }
            this.write(updated, X_FORWARDED_PORT_HEADER, port, this.isPortAppend());
        }
        if (this.isHostEnabled()) {
            String host = this.toHostHeader(request);
            this.write(updated, X_FORWARDED_HOST_HEADER, host, this.isHostAppend());
        }
        return updated;
    }

    private void updateRequest(HttpHeaders updated, URI originalUri, String originalUriPath, String requestUriPath) {
        String prefix;
        if (requestUriPath != null && originalUriPath.endsWith(requestUriPath) && (prefix = XForwardedHeadersFilter.substringBeforeLast(originalUriPath, requestUriPath)) != null && prefix.length() > 0 && prefix.length() <= originalUri.getPath().length()) {
            this.write(updated, X_FORWARDED_PREFIX_HEADER, prefix, this.isPrefixAppend());
        }
    }

    private static String substringBeforeLast(String str, String separator) {
        if (ObjectUtils.isEmpty((Object)str) || ObjectUtils.isEmpty((Object)separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append) {
        this.write(headers, name, value, append, s -> true);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append, Predicate<String> shouldWrite) {
        if (append) {
            if (value != null) {
                headers.add(name, value);
            }
            if (headers.containsKey((Object)name)) {
                List<String> values = headers.get((Object)name).stream().filter(shouldWrite).toList();
                String delimitedValue = StringUtils.collectionToCommaDelimitedString(values);
                headers.set(name, delimitedValue);
            }
        } else if (value != null && shouldWrite.test(value)) {
            headers.set(name, value);
        }
    }

    private int getDefaultPort(String scheme) {
        return HTTPS_SCHEME.equals(scheme) ? 443 : 80;
    }

    private String toHostHeader(ServerHttpRequest request) {
        int port = request.getURI().getPort();
        String host = request.getURI().getHost();
        String scheme = request.getURI().getScheme();
        if (port < 0 || port == 80 && HTTP_SCHEME.equals(scheme) || port == 443 && HTTPS_SCHEME.equals(scheme)) {
            return host;
        }
        return host + ":" + port;
    }

    private String stripTrailingSlash(URI uri) {
        if (uri.getPath().endsWith("/")) {
            return uri.getPath().substring(0, uri.getPath().length() - 1);
        }
        return uri.getPath();
    }
}

