/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.reactive.HttpHandlerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.config.GatewayMetricsProperties;
import org.springframework.cloud.gateway.filter.GatewayMetricsFilter;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionMetrics;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayHttpTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayPathTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayRouteTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.PropertiesTagsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.gateway.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GatewayMetricsProperties.class})
@AutoConfigureBefore(value={HttpHandlerAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={DispatcherHandler.class, MeterRegistry.class, MetricsAutoConfiguration.class})
public class GatewayMetricsAutoConfiguration {
    @Bean
    public GatewayHttpTagsProvider gatewayHttpTagsProvider() {
        return new GatewayHttpTagsProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"spring.cloud.gateway.metrics.tags.path.enabled"})
    public GatewayPathTagsProvider gatewayPathTagsProvider() {
        return new GatewayPathTagsProvider();
    }

    @Bean
    public GatewayRouteTagsProvider gatewayRouteTagsProvider() {
        return new GatewayRouteTagsProvider();
    }

    @Bean
    public PropertiesTagsProvider propertiesTagsProvider(GatewayMetricsProperties properties) {
        return new PropertiesTagsProvider(properties.getTags());
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(name={"spring.cloud.gateway.metrics.enabled"}, matchIfMissing=true)
    public GatewayMetricsFilter gatewayMetricFilter(MeterRegistry meterRegistry, List<GatewayTagsProvider> tagsProviders, GatewayMetricsProperties properties) {
        return new GatewayMetricsFilter(meterRegistry, tagsProviders, properties.getPrefix());
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(name={"spring.cloud.gateway.metrics.enabled"}, matchIfMissing=true)
    public RouteDefinitionMetrics routeDefinitionMetrics(MeterRegistry meterRegistry, RouteDefinitionLocator routeDefinitionLocator, GatewayMetricsProperties properties) {
        return new RouteDefinitionMetrics(meterRegistry, routeDefinitionLocator, properties.getPrefix());
    }
}

