/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import com.netflix.hystrix.exception.HystrixRuntimeException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.support.ServiceUnavailableException;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

public class SpringCloudCircuitBreakerHystrixFilterFactory
extends SpringCloudCircuitBreakerFilterFactory {
    public SpringCloudCircuitBreakerHystrixFilterFactory(ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandlerProvider) {
        super(reactiveCircuitBreakerFactory, dispatcherHandlerProvider);
    }

    @Override
    protected Mono<Void> handleErrorWithoutFallback(Throwable throwable) {
        if (throwable instanceof HystrixRuntimeException) {
            HystrixRuntimeException e = (HystrixRuntimeException)throwable;
            HystrixRuntimeException.FailureType failureType = e.getFailureType();
            switch (failureType) {
                case TIMEOUT: {
                    return Mono.error((Throwable)new TimeoutException());
                }
                case SHORTCIRCUIT: {
                    return Mono.error((Throwable)new ServiceUnavailableException());
                }
                case COMMAND_EXCEPTION: {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof ResponseStatusException) && AnnotatedElementUtils.findMergedAnnotation(cause.getClass(), ResponseStatus.class) == null) break;
                    return Mono.error((Throwable)cause);
                }
            }
        }
        return Mono.error((Throwable)throwable);
    }
}

