/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.constraints.NotBlank;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.ApiVersionStrategy;
import org.springframework.web.reactive.accept.DefaultApiVersionStrategy;
import org.springframework.web.server.ServerWebExchange;

public class VersionRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final Log log = LogFactory.getLog(VersionRoutePredicateFactory.class);
    private final @Nullable ApiVersionStrategy apiVersionStrategy;

    public VersionRoutePredicateFactory(@Nullable ApiVersionStrategy apiVersionStrategy) {
        super(Config.class);
        this.apiVersionStrategy = apiVersionStrategy;
    }

    private static void traceMatch(String prefix, @Nullable Object desired, @Nullable Object actual, boolean match) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual));
        }
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return List.of("version");
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        ApiVersionStrategy apiVersionStrategy = this.apiVersionStrategy;
        if (apiVersionStrategy instanceof DefaultApiVersionStrategy) {
            DefaultApiVersionStrategy strategy = (DefaultApiVersionStrategy)apiVersionStrategy;
            String version = config.version;
            if (version != null) {
                strategy.addMappedVersion(new String[]{version.endsWith("+") ? version.substring(0, version.length() - 1) : version});
            }
        }
        return new GatewayPredicate(){
            final /* synthetic */ VersionRoutePredicateFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(ServerWebExchange exchange) {
                Comparable requestVersion;
                ServerHttpRequest request = exchange.getRequest();
                if (config.parsedVersion == null) {
                    Assert.state((this.this$0.apiVersionStrategy != null ? 1 : 0) != 0, (String)"No ApiVersionStrategy to parse version with");
                    String version = config.version;
                    Objects.requireNonNull(version, "version must not be null");
                    config.parsedVersion = this.this$0.apiVersionStrategy.parseVersion(version);
                }
                if ((requestVersion = (Comparable)request.getAttributes().get(HandlerMapping.API_VERSION_ATTRIBUTE)) == null) {
                    VersionRoutePredicateFactory.traceMatch("Version", config.version, null, false);
                    return false;
                }
                int result = this.compareVersions(config.parsedVersion, requestVersion);
                boolean match = config.baselineVersion ? result <= 0 : result == 0;
                VersionRoutePredicateFactory.traceMatch("Version", config.version, requestVersion, match);
                return match;
            }

            private <V extends Comparable<V>> int compareVersions(Object v1, Object v2) {
                return ((Comparable)v1).compareTo((Comparable)v2);
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Version: %s", config.version + (config.baselineVersion ? "+" : ""));
            }
        };
    }

    public static class Config {
        private boolean baselineVersion;
        @NotBlank
        private @Nullable String version;
        private @Nullable String originalVersion;
        private @Nullable Comparable<?> parsedVersion;

        public boolean isBaselineVersion() {
            return this.baselineVersion;
        }

        public @Nullable String getOriginalVersion() {
            return this.originalVersion;
        }

        public @Nullable Comparable<?> getParsedVersion() {
            return this.parsedVersion;
        }

        public @Nullable String getVersion() {
            return this.version;
        }

        public Config setVersion(Object version) {
            if (version instanceof String) {
                String s;
                this.originalVersion = s = (String)version;
                this.baselineVersion = s.endsWith("+");
                this.version = Config.initVersion(s, this.baselineVersion);
            } else {
                this.baselineVersion = false;
                this.version = version.toString();
                this.originalVersion = version.toString();
                this.parsedVersion = (Comparable)version;
            }
            return this;
        }

        private static String initVersion(String version, boolean baselineVersion) {
            return baselineVersion ? version.substring(0, version.length() - 1) : version;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("baselineVersion", this.baselineVersion).append("version", (Object)this.version).toString();
        }
    }
}

