/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class HeaderRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String HEADER_KEY = "header";
    public static final String REGEXP_KEY = "regexp";

    public HeaderRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(HEADER_KEY, REGEXP_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        final Pattern pattern = StringUtils.hasText((String)config.regexp) ? Pattern.compile(config.regexp) : null;
        return new GatewayPredicate(){
            final /* synthetic */ HeaderRoutePredicateFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(ServerWebExchange exchange) {
                if (!StringUtils.hasText((String)config.header)) {
                    return false;
                }
                List values = exchange.getRequest().getHeaders().getValuesAsList(config.header);
                if (values.isEmpty()) {
                    return false;
                }
                if (pattern != null) {
                    for (int i = 0; i < values.size(); ++i) {
                        String value = (String)values.get(i);
                        if (!pattern.asMatchPredicate().test(value)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Header: %s regexp=%s", config.header, config.regexp);
            }
        };
    }

    public static class Config {
        @NotEmpty
        private @Nullable String header;
        private @Nullable String regexp;

        public @Nullable String getHeader() {
            return this.header;
        }

        public Config setHeader(String header) {
            this.header = header;
            return this;
        }

        public @Nullable String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(@Nullable String regexp) {
            this.regexp = regexp;
            return this;
        }
    }
}

