/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Mono;

public class PrefixPathGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String PREFIX_KEY = "prefix";
    private static final Log log = LogFactory.getLog(PrefixPathGatewayFilterFactory.class);

    public PrefixPathGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(PREFIX_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final UriTemplate uriTemplate;
            final /* synthetic */ PrefixPathGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
                this.uriTemplate = new UriTemplate(Objects.requireNonNull(config.prefix, "prefix must not be null"));
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                boolean alreadyPrefixed = (Boolean)exchange.getAttributeOrDefault(ServerWebExchangeUtils.GATEWAY_ALREADY_PREFIXED_ATTR, (Object)false);
                if (alreadyPrefixed) {
                    return chain.filter(exchange);
                }
                exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ALREADY_PREFIXED_ATTR, true);
                ServerHttpRequest req = exchange.getRequest();
                ServerWebExchangeUtils.addOriginalRequestUrl(exchange, req.getURI());
                Map<String, String> uriVariables = ServerWebExchangeUtils.getUriTemplateVariables(exchange);
                URI uri = this.uriTemplate.expand(uriVariables);
                String newPath = uri.getRawPath() + req.getURI().getRawPath();
                exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
                ServerHttpRequest request = req.mutate().path(newPath).build();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Prefixed URI with: " + config.prefix + " -> " + String.valueOf(request.getURI())));
                }
                return chain.filter(exchange.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(PrefixPathGatewayFilterFactory.PREFIX_KEY, (Object)config.getPrefix()).toString();
            }
        };
    }

    public static class Config {
        private @Nullable String prefix;

        public @Nullable String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

