/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MapRequestHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String FROM_HEADER_KEY = "fromHeader";
    public static final String TO_HEADER_KEY = "toHeader";

    public MapRequestHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(FROM_HEADER_KEY, TO_HEADER_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final /* synthetic */ MapRequestHeaderGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                String fromHeader = Objects.requireNonNull(config.getFromHeader(), "fromHeader must be set");
                String toHeader = Objects.requireNonNull(config.getToHeader(), "toHeader must be set");
                if (!exchange.getRequest().getHeaders().containsHeader(fromHeader)) {
                    return chain.filter(exchange);
                }
                List headerValues = exchange.getRequest().getHeaders().get(fromHeader);
                if (headerValues == null) {
                    return chain.filter(exchange);
                }
                ServerHttpRequest request = exchange.getRequest().mutate().headers(i -> i.addAll(toHeader, headerValues)).build();
                return chain.filter(exchange.mutate().request(request).build());
            }

            public String toString() {
                String fromHeader = config.getFromHeader();
                String toHeader = config.getToHeader();
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(MapRequestHeaderGatewayFilterFactory.FROM_HEADER_KEY, (Object)(fromHeader != null ? fromHeader : "")).append(MapRequestHeaderGatewayFilterFactory.TO_HEADER_KEY, (Object)(toHeader != null ? toHeader : "")).toString();
            }
        };
    }

    public static class Config {
        private @Nullable String fromHeader;
        private @Nullable String toHeader;

        public @Nullable String getFromHeader() {
            return this.fromHeader;
        }

        public Config setFromHeader(String fromHeader) {
            this.fromHeader = fromHeader;
            return this;
        }

        public @Nullable String getToHeader() {
            return this.toHeader;
        }

        public Config setToHeader(String toHeader) {
            this.toHeader = toHeader;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append(MapRequestHeaderGatewayFilterFactory.FROM_HEADER_KEY, (Object)this.fromHeader).append(MapRequestHeaderGatewayFilterFactory.TO_HEADER_KEY, (Object)this.toHeader).toString();
        }
    }
}

