/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AddResponseHeaderGatewayFilterFactory
extends AbstractNameValueGatewayFilterFactory {
    private static final String OVERRIDE_KEY = "override";

    @Override
    public Class getConfigClass() {
        return Config.class;
    }

    @Override
    public AbstractNameValueGatewayFilterFactory.NameValueConfig newConfig() {
        return new Config();
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", "value", OVERRIDE_KEY);
    }

    @Override
    public GatewayFilter apply(final AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        return new GatewayFilter(){
            final /* synthetic */ AddResponseHeaderGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> this.this$0.addHeader(exchange, config)));
            }

            public String toString() {
                String name = config.getName();
                String value = config.getValue();
                if (config instanceof Config) {
                    return GatewayToStringStyler.filterToStringCreator(this.this$0).append("name", (Object)(name != null ? name : "")).append("value", (Object)(value != null ? value : "")).append(AddResponseHeaderGatewayFilterFactory.OVERRIDE_KEY, ((Config)config).isOverride()).toString();
                }
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(name != null ? name : "", (Object)(value != null ? value : "")).toString();
            }
        };
    }

    void addHeader(ServerWebExchange exchange, AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        if (!exchange.getResponse().isCommitted()) {
            String name = Objects.requireNonNull(config.getName(), "name must not be null");
            String rawValue = Objects.requireNonNull(config.getValue(), "value must not be null");
            String value = ServerWebExchangeUtils.expand(exchange, rawValue);
            HttpHeaders headers = exchange.getResponse().getHeaders();
            boolean override = true;
            if (config instanceof Config) {
                override = ((Config)config).isOverride();
            }
            if (override) {
                headers.add(name, value);
            } else {
                boolean headerIsMissingOrBlank = headers.getOrEmpty(name).stream().allMatch(h -> !StringUtils.hasText((String)h));
                if (headerIsMissingOrBlank) {
                    headers.add(name, value);
                }
            }
        }
    }

    public static class Config
    extends AbstractNameValueGatewayFilterFactory.NameValueConfig {
        private boolean override = true;

        public boolean isOverride() {
            return this.override;
        }

        public Config setOverride(boolean override) {
            this.override = override;
            return this;
        }

        @Override
        public String toString() {
            return new ToStringCreator((Object)this).append("name", (Object)this.name).append("value", (Object)this.value).append(AddResponseHeaderGatewayFilterFactory.OVERRIDE_KEY, this.override).toString();
        }
    }
}

