/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cloud.gateway.event.EnableBodyCachingEvent;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AdaptCachedBodyGlobalFilter
implements GlobalFilter,
Ordered,
ApplicationListener<EnableBodyCachingEvent> {
    private ConcurrentMap<String, Boolean> routesToCache = new ConcurrentHashMap<String, Boolean>();

    public void onApplicationEvent(EnableBodyCachingEvent event) {
        this.routesToCache.putIfAbsent(event.getRouteId(), true);
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest cachedRequest = (ServerHttpRequest)exchange.getAttribute("cachedServerHttpRequestDecorator");
        if (cachedRequest != null) {
            exchange.getAttributes().remove("cachedServerHttpRequestDecorator");
            return chain.filter(exchange.mutate().request(cachedRequest).build());
        }
        DataBuffer body = (DataBuffer)exchange.getAttribute("cachedRequestBody");
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        if (body != null || route == null || !this.routesToCache.containsKey(route.getId())) {
            return chain.filter(exchange);
        }
        return ServerWebExchangeUtils.cacheRequestBody(exchange, serverHttpRequest -> {
            if (serverHttpRequest == exchange.getRequest()) {
                return chain.filter(exchange);
            }
            return chain.filter(exchange.mutate().request(serverHttpRequest).build());
        });
    }

    public int getOrder() {
        return -2147482648;
    }
}

