/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import jakarta.servlet.http.Cookie;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class LoadBalancerFilterFunctions {
    private static final Log log = LogFactory.getLog(LoadBalancerFilterFunctions.class);

    private LoadBalancerFilterFunctions() {
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> lb(String serviceId) {
        return LoadBalancerFilterFunctions.lb(serviceId, LoadBalancerUriTools::reconstructURI);
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> lb(String serviceId, BiFunction<ServiceInstance, URI, URI> reconstructUriFunction) {
        return (request, next) -> {
            MvcUtils.addOriginalRequestUrl(request, request.uri());
            LoadBalancerClientFactory clientFactory = (LoadBalancerClientFactory)MvcUtils.getApplicationContext(request).getBean(LoadBalancerClientFactory.class);
            Set supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)clientFactory.getInstances(serviceId, LoadBalancerLifecycle.class), RequestDataContext.class, ResponseData.class, ServiceInstance.class);
            RequestData requestData = new RequestData(request.method(), request.uri(), request.headers().asHttpHeaders(), LoadBalancerFilterFunctions.buildCookies((MultiValueMap<String, Cookie>)request.cookies()), request.attributes());
            DefaultRequest lbRequest = new DefaultRequest((Object)new RequestDataContext(requestData, LoadBalancerFilterFunctions.getHint(clientFactory, serviceId)));
            LoadBalancerClient loadBalancerClient = (LoadBalancerClient)clientFactory.getInstance(serviceId, LoadBalancerClient.class);
            if (loadBalancerClient == null) {
                throw new HttpServerErrorException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "No loadbalancer available for " + serviceId);
            }
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart((Request)lbRequest));
            ServiceInstance retrievedInstance = loadBalancerClient.choose(serviceId, (Request)lbRequest);
            if (retrievedInstance == null) {
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, (Request)lbRequest)));
                throw new HttpServerErrorException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Unable to find instance for " + serviceId);
            }
            URI uri = request.uri();
            String scheme = retrievedInstance.isSecure() ? "https" : "http";
            DelegatingServiceInstance serviceInstance = new DelegatingServiceInstance(retrievedInstance, scheme);
            URI requestUrl = (URI)reconstructUriFunction.apply(serviceInstance, uri);
            if (log.isTraceEnabled()) {
                log.trace((Object)("LoadBalancerClientFilter url chosen: " + requestUrl));
            }
            MvcUtils.setRequestUrl(request, requestUrl);
            DefaultResponse defaultResponse = new DefaultResponse((ServiceInstance)serviceInstance);
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStartRequest((Request)lbRequest, (Response)defaultResponse));
            try {
                ServerResponse serverResponse = next.handle(request);
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, (Request)lbRequest, (Response)defaultResponse, (Object)serverResponse)));
                return serverResponse;
            }
            catch (Exception e) {
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)e, (Request)lbRequest, (Response)defaultResponse)));
                throw new RuntimeException(e);
            }
        };
    }

    private static String getHint(LoadBalancerClientFactory clientFactory, String serviceId) {
        LoadBalancerProperties loadBalancerProperties = clientFactory.getProperties(serviceId);
        Map hints = loadBalancerProperties.getHint();
        String defaultHint = hints.getOrDefault("default", "default");
        String hintPropertyValue = (String)hints.get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }

    private static MultiValueMap<String, String> buildCookies(MultiValueMap<String, Cookie> cookies) {
        HttpHeaders newCookies = new HttpHeaders();
        if (cookies != null) {
            cookies.forEach((key, value) -> value.forEach(cookie -> newCookies.put(cookie.getName(), Collections.singletonList(cookie.getValue()))));
        }
        return newCookies;
    }

    static class DelegatingServiceInstance
    implements ServiceInstance {
        final ServiceInstance delegate;
        private String overrideScheme;

        DelegatingServiceInstance(ServiceInstance delegate, String overrideScheme) {
            this.delegate = delegate;
            this.overrideScheme = overrideScheme;
        }

        public String getServiceId() {
            return this.delegate.getServiceId();
        }

        public String getHost() {
            return this.delegate.getHost();
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public boolean isSecure() {
            if ("https".equals(this.overrideScheme) || "wss".equals(this.overrideScheme)) {
                return true;
            }
            return this.delegate.isSecure();
        }

        public URI getUri() {
            return this.delegate.getUri();
        }

        public Map<String, String> getMetadata() {
            return this.delegate.getMetadata();
        }

        public String getScheme() {
            String scheme = this.delegate.getScheme();
            if (scheme != null) {
                return scheme;
            }
            return this.overrideScheme;
        }
    }
}

